package dev.cammiescorner.fireworkfrenzy.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.cammiescorner.fireworkfrenzy.FireworkFrenzyConfig;
import dev.cammiescorner.fireworkfrenzy.component.BlastJumper;
import dev.cammiescorner.fireworkfrenzy.data.FireworkFrenzyEnchantments;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyComponents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;

@Mixin(class_1764.class)
public abstract class CrossbowItemMixin extends class_1811 {
	@Unique private static final ThreadLocal<BlastJumper> BLAST_JUMPER_COMPONENT = new ThreadLocal<>();

	@Shadow public abstract int method_7881(class_1799 stack, class_1309 entity);

	private CrossbowItemMixin(class_1793 properties) {
		super(properties);
		throw new UnsupportedOperationException();
	}

	@Inject(method = "onUseTick", at = @At("HEAD"))
	private void setBlastJumperComponent(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration, CallbackInfo ci) {
		BLAST_JUMPER_COMPONENT.set(FireworkFrenzyComponents.BLAST_JUMPER.getNullable(livingEntity));
	}

	@Inject(method = "onUseTick", at = @At("RETURN"))
	private void stopUsingItem(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration, CallbackInfo ci) {
		var component = BLAST_JUMPER_COMPONENT.get();

		if(component != null && component.isBlastJumping() && FireworkFrenzyEnchantments.hasAirStrike(level.method_30349(), stack) && class_1764.method_7770(method_7881(stack, livingEntity) - remainingUseDuration, stack, livingEntity) == 1.0F)
			livingEntity.method_6075();

		BLAST_JUMPER_COMPONENT.remove();
	}

	@ModifyReturnValue(method = "getChargeDuration", at = @At("RETURN"))
	private static int airstrikeChargeDuration(int original, class_1799 stack, class_1309 shooter) {
		if(FireworkFrenzyEnchantments.hasAirStrike(shooter.method_56673(), stack)) {
			var jumper = BLAST_JUMPER_COMPONENT.get();
			return jumper != null && jumper.isBlastJumping() ? FireworkFrenzyConfig.airStrikeJumpingChargeTime : FireworkFrenzyConfig.airStrikeGroundedChargeTime;
		}

		return original;
	}

	@ModifyConstant(method = "getChargeDuration", constant = @Constant(floatValue = 20))
	private static float configurableChargeTime(float constant) {
		return FireworkFrenzyConfig.crossbowChargeTime;
	}

	@ModifyReturnValue(method = "getChargeDuration", at = @At("RETURN"))
	private static int changeDefaultPullTimes(int original) {
		return Math.max(1, original);
	}

	@ModifyReturnValue(method = "getAllSupportedProjectiles", at = @At("RETURN"))
	public Predicate<class_1799> getProjectiles(Predicate<class_1799> original) {
		if (FireworkFrenzyConfig.crossbowUseRocketsFromInventory) {
			return field_18282;
		}

		return original;
	}
}
