package dev.cammiescorner.fireworkfrenzy.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.cammiescorner.fireworkfrenzy.FireworkFrenzyConfig;
import dev.cammiescorner.fireworkfrenzy.compat.ExplosiveEnhancementCompat;
import dev.cammiescorner.fireworkfrenzy.compat.FireworkFrenzyCompat;
import dev.cammiescorner.fireworkfrenzy.component.BlastJumper;
import dev.cammiescorner.fireworkfrenzy.data.FireworkFrenzyEnchantments;
import dev.cammiescorner.fireworkfrenzy.entities.DamageCloudEntity;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyComponents;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyCriteriaTriggers;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyDataComponents;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyEntityTypes;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_3222;
import net.minecraft.class_3856;
import net.minecraft.class_3966;
import net.minecraft.class_6024;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import net.minecraft.class_9381;

@Mixin(class_1671.class)
public abstract class FireworkRocketEntityMixin extends class_1676 implements class_3856 {
	@Unique private class_1309 directTarget;

	@Shadow @Final private static class_2940<class_1799> DATA_ID_FIREWORKS_ITEM;
	@Shadow private @Nullable class_1309 attachedToEntity;
	@Shadow private int lifetime;
	@Shadow protected abstract boolean hasExplosion();
	@Shadow protected abstract List<class_9283> getExplosions();
	@Shadow public abstract class_1799 method_7495();

	private FireworkRocketEntityMixin(class_1299<? extends class_1676> entityType, class_1937 level) {
		super(entityType, level);
		throw new UnsupportedOperationException();
	}

	@Inject(method = "<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)V", at = @At("TAIL"), locals = LocalCapture.CAPTURE_FAILSOFT)
	void noRandomFuse(class_1937 level, double x, double y, double z, class_1799 stack, CallbackInfo ci, int i) {
		method_18800(0.0D, 0.05D, 0.0D);

		if(FireworkFrenzyEnchantments.hasFixedFuse(method_56673(), field_6011.method_12789(DATA_ID_FIREWORKS_ITEM)))
			lifetime = 10 * i + 6;
	}

	@ModifyArg(method = "dealExplosionDamage", at = @At(value = "INVOKE",
			target = "Lnet/minecraft/world/phys/AABB;inflate(D)Lnet/minecraft/world/phys/AABB;"
	))
	private double blastRadius(double original, @Share("blastSize") LocalFloatRef blastSize, @Share("knockbackAmount") LocalFloatRef knockbackAmountRef, @Share("glowingDuration") LocalIntRef glowingDurationRef) {
		class_9284 data = field_6011.method_12789(DATA_ID_FIREWORKS_ITEM).method_57824(class_9334.field_49616);
		Set<class_9283.class_1782> types = EnumSet.noneOf(class_9283.class_1782.class);
		int glowingDuration = 0;
		float knockbackAmount = 1.0F;

		if(data != null) {
			for(class_9283 explosion : data.comp_2392()) {
				types.add(explosion.comp_2386());

				if(explosion.comp_2389())
					knockbackAmount += 0.1f;
				if(explosion.comp_2390())
					glowingDuration += 20;
			}
		}
		knockbackAmountRef.set(knockbackAmount);
		glowingDurationRef.set(glowingDuration);

		if(types.contains(class_9283.class_1782.field_7977))
			blastSize.set(5f);
		else if(types.contains(class_9283.class_1782.field_7973))
			blastSize.set(5f);
		else
			blastSize.set(3f);

		return blastSize.get();
	}

	@Inject(method = "dealExplosionDamage", at = @At(value = "INVOKE",
			target = "Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z",
			ordinal = 1
	), locals = LocalCapture.CAPTURE_FAILSOFT)
	public void explodePostDamage(CallbackInfo ci, float damage, List<class_9283> list, double d, class_243 vec3, List<class_1309> list2, Iterator<class_1309> var7, class_1309 target, boolean bl, float g, @Share("target") LocalRef<class_1309> targetRef, @Share("blastSize") LocalFloatRef blastSize, @Share("knockbackAmount") LocalFloatRef knockbackAmount, @Share("glowingDuration") LocalIntRef glowingDuration) {
		targetRef.set(target);

		if(hasExplosion()) {
			class_1282 source = method_48923().method_48805((class_1671) (Object) this, method_24921());

			if(!target.method_6061(source)) {
				var adjustedPos = method_19538().method_1031(0.0, method_17682() / 2.0, 0.0);
				var adjustedTargetPos = target.method_19538().method_1031(0.0, target.method_17682() / 2.0, 0.0);
				class_239 hitResult = class_1675.method_18075(this, adjustedPos, adjustedTargetPos, method_5829().method_1014(blastSize.get()), entity -> entity == target, adjustedPos.method_1025(adjustedTargetPos));

				if(hitResult != null && hitResult.method_17783() == class_239.class_240.field_1331) {
					var owner = method_24921();
					double distance = Math.max(1, hitResult.method_17784().method_1022(adjustedPos));
					float fireworkDamage = (target instanceof class_1657 ? FireworkFrenzyConfig.playerDamage : FireworkFrenzyConfig.mobDamage) * list.size() + (method_7495().method_57825(FireworkFrenzyDataComponents.FIREBALL.get(), false) ? FireworkFrenzyConfig.fireballDamageBonus : 0);

					// calculate damage falloff
					if(FireworkFrenzyConfig.rocketsHaveDamageFalloff && owner != null)
						fireworkDamage = Math.max(FireworkFrenzyConfig.minFalloffMultiplier * fireworkDamage, fireworkDamage - Math.max(0, this.method_5739(owner) - FireworkFrenzyConfig.rocketDamageFalloffStartDistance) * FireworkFrenzyConfig.rocketDamageFalloffPerMeter);

					// calculate air strike damage
					if(method_59958() != null && FireworkFrenzyEnchantments.hasAirStrike(method_56673(), method_59958()) && owner != null && FireworkFrenzyComponents.BLAST_JUMPER.maybeGet(owner).map(BlastJumper::isBlastJumping).orElse(false))
						fireworkDamage *= FireworkFrenzyConfig.airStrikeDamageMultiplier;

					// calculate damage fall-off
					if(target != directTarget) {
						fireworkDamage = Math.max(1.0F, fireworkDamage / (float) distance);
					}

					// deal damage
					var result = target.method_5643(source, fireworkDamage);

					// apply glowing effect
					if(result && glowingDuration.get() > 0) {
						target.method_6092(new class_1293(class_1294.field_5912, glowingDuration.get(), 0, false, false));
					}

					if(FireworkFrenzyConfig.allowRocketJumping) {
						double multiplier = ((list.size() + (method_7495().method_57825(FireworkFrenzyDataComponents.FIREBALL.get(), false) ? 1 : 0)) * 0.3) * knockbackAmount.get() * (target == owner ? FireworkFrenzyConfig.rocketJumpKnockbackMultiplier : FireworkFrenzyConfig.defaultKnockbackMultiplier);
						var targetVelocity = target.method_18798();

						targetVelocity = new class_243(targetVelocity.method_10216(), Math.max(1, Math.abs(targetVelocity.method_10214())), targetVelocity.method_10215()).method_1021(multiplier / distance);
						target.method_18799(targetVelocity);
						target.field_6037 = true;

						if(target instanceof class_3222 serverPlayer) {
							FireworkFrenzyCriteriaTriggers.BLAST_JUMP.get().trigger(serverPlayer, targetVelocity.method_1033());
						}
					}
				}
			}
		}

		if(FireworkFrenzyConfig.allowRocketJumping) {
			FireworkFrenzyComponents.BLAST_JUMPER.maybeGet(target).ifPresent(component -> {
				component.setTimeOnGround(0);
				component.setBlastJumping(true);
				component.sync();
			});
		}
	}

	@Inject(method = "dealExplosionDamage", at = @At("TAIL"), locals = LocalCapture.CAPTURE_FAILSOFT)
	private void spawnPotionCloud(CallbackInfo info, @Share("target") LocalRef<class_1309> targetRef, @Share("blastSize")LocalFloatRef blastSize) {
		class_1799 stack = field_6011.method_12789(DATA_ID_FIREWORKS_ITEM);

		if(stack.method_7960())
			return;

		class_9284 data = stack.method_57824(class_9334.field_49616);
		Set<class_9283.class_1782> types = EnumSet.noneOf(class_9283.class_1782.class);

		for(class_9283 explosion : data.comp_2392())
			types.add(explosion.comp_2386());

		if(types.contains(class_9283.class_1782.field_7973)) {
			DamageCloudEntity cloud = FireworkFrenzyEntityTypes.DAMAGE_CLOUD.get().method_5883(method_37908());

			if(cloud != null) {
				cloud.method_5603(blastSize.get());
				cloud.method_5607(attachedToEntity);
				cloud.method_5604(200);
				cloud.method_5608(class_9381.method_58256(class_2398.field_11226, 0xf8d26a));
				cloud.method_33574(method_19538().method_1031(0, -cloud.method_5599(), 0));
				method_37908().method_8649(cloud);
			}
		}

		if(types.contains(class_9283.class_1782.field_7970) && targetRef.get() instanceof class_1657 player && player.method_6039() && field_5974.method_43057() < FireworkFrenzyConfig.burstDisableShieldChance) {
			player.method_7357().method_7906(class_1802.field_8255, 50);
			player.method_6021();
			method_37908().method_8421(this, class_6024.field_29998);
		}
	}

	@Inject(method = "onHitEntity", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/projectile/FireworkRocketEntity;explode()V"))
	public void onDirectHit(class_3966 entityHitResult, CallbackInfo info) {
		if(entityHitResult.method_17782() instanceof class_1309 target) {
			directTarget = target;
		}
	}

	@WrapWithCondition(method = "handleEntityEvent", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;createFireworks(DDDDDDLjava/util/List;)V"))
	public boolean inhibitFireworkParticles(class_1937 instance, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, List<class_9283> explosions) {
		return !FireworkFrenzyCompat.EXPLOSIVE_ENHANCEMENT.isEnabled();
	}

	@Inject(method = "handleEntityEvent", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;createFireworks(DDDDDDLjava/util/List;)V"), locals = LocalCapture.CAPTURE_FAILSOFT)
	public void explosiveEnhancement(byte id, CallbackInfo ci, class_243 vec3) {
		if(FireworkFrenzyCompat.EXPLOSIVE_ENHANCEMENT.isEnabled()) {
			if(method_7495().method_57825(FireworkFrenzyDataComponents.FIREBALL.get(), false))
				ExplosiveEnhancementCompat.spawnEnhancedBooms(method_37908(), method_23317(), method_23318(), method_23321(), 1.25f);
			else
				method_37908().method_8547(method_23317(), method_23318(), method_23321(), vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), getExplosions());
		}
	}

	@ModifyArg(method = "dealExplosionDamage", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", ordinal = 0))
	public float noSelfDamage(class_1282 source, float amount) {
		return 0;
	}

	@ModifyArg(method = "dealExplosionDamage", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", ordinal = 1))
	public float noCrossbowDamage(class_1282 source, float amount) {
		return 0;
	}
}
