package dev.cammiescorner.fireworkfrenzy.mixin;

import dev.cammiescorner.fireworkfrenzy.FireworkFrenzyConfig;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyComponents;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyDataComponents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1781;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_9284;

@Mixin(class_1781.class)
public abstract class FireworkRocketItemMixin extends class_1792 {
	public FireworkRocketItemMixin(class_1793 properties) {
		super(properties);
		throw new UnsupportedOperationException();
	}

	@Inject(method = "use", at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"))
	public void onUse(class_1937 level, class_1657 player, class_1268 usedHand, CallbackInfoReturnable<class_1271<class_1799>> cir) {
		if (FireworkFrenzyConfig.boostCancelsRocketJumping) {
			var component = player.getComponent(FireworkFrenzyComponents.BLAST_JUMPER);
			if (component.isBlastJumping()) {
				component.setBlastJumping(false);
				component.sync();
			}
		}
	}

	@Inject(method = "appendHoverText", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/component/Fireworks;addToTooltip(Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/function/Consumer;Lnet/minecraft/world/item/TooltipFlag;)V"), locals = LocalCapture.CAPTURE_FAILSOFT)
	public void addTooltip(class_1799 stack, class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag, CallbackInfo ci, class_9284 fireworks) {
		if(FireworkFrenzyConfig.showFireworkDamageTooltip) {
			var hasFireball = stack.method_57825(FireworkFrenzyDataComponents.FIREBALL.get(), false);
			float mobDamage = FireworkFrenzyConfig.mobDamage * fireworks.comp_2392().size();
			float playerDamage = FireworkFrenzyConfig.playerDamage * fireworks.comp_2392().size();

			if(hasFireball) {
				mobDamage += FireworkFrenzyConfig.fireballDamageBonus;
				playerDamage += FireworkFrenzyConfig.fireballDamageBonus;
			}

			tooltipComponents.add(class_2561.method_43469("tooltip.fireworkfrenzy.rocket_damage_base", mobDamage).method_27692(class_124.field_1080));

			if(FireworkFrenzyConfig.mobDamage != FireworkFrenzyConfig.playerDamage)
				tooltipComponents.add(class_2561.method_43469("tooltip.fireworkfrenzy.rocket_damage_players", playerDamage).method_27692(class_124.field_1080));

			if(hasFireball)
				tooltipComponents.add(class_2561.method_43471("tooltip.fireworkfrenzy.rocket_has_fireball").method_27695(class_124.field_1065, class_124.field_1056));
		}
	}
}
