package dev.cammiescorner.fireworkfrenzy.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.cammiescorner.fireworkfrenzy.compat.ExplosiveEnhancementCompat;
import dev.cammiescorner.fireworkfrenzy.compat.FireworkFrenzyCompat;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyDataComponents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1851;
import net.minecraft.class_1852;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9283;
import net.minecraft.class_9694;

@Mixin(class_1851.class)
public abstract class FireworkRocketRecipeMixin extends class_1852 {
	private FireworkRocketRecipeMixin(class_7710 category) {
		super(category);
		throw new UnsupportedOperationException();
	}

	@Inject(method = "matches(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/world/level/Level;)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;isEmpty()Z"), locals = LocalCapture.CAPTURE_FAILSOFT)
	public void captureStack(class_9694 input, class_1937 level, CallbackInfoReturnable<Boolean> cir, boolean bl, int i, int j, class_1799 itemStack, @Share("itemStack") LocalRef<class_1799> stackRef) {
		stackRef.set(itemStack);
	}

	@ModifyExpressionValue(method = "matches(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/world/level/Level;)Z", slice = @Slice(from = @At(value = "FIELD", target = "Lnet/minecraft/world/item/crafting/FireworkRocketRecipe;STAR_INGREDIENT:Lnet/minecraft/world/item/crafting/Ingredient;")), at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/crafting/Ingredient;test(Lnet/minecraft/world/item/ItemStack;)Z"))
	public boolean allowFireball(boolean original, @Share("itemStack") LocalRef<class_1799> stackRef) {
		return original || FireworkFrenzyCompat.EXPLOSIVE_ENHANCEMENT.orElse(() -> () -> ExplosiveEnhancementCompat.FIREBALL_INGREDIENT.method_8093(stackRef.get()), false);
	}

	@Inject(method = "assemble(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;"), locals = LocalCapture.CAPTURE_FAILSOFT)
	public void addFireballTag(class_9694 input, class_7225.class_7874 registries, CallbackInfoReturnable<class_1799> cir, List<class_9283> list, int i, class_1799 itemStack2) {
		FireworkFrenzyCompat.EXPLOSIVE_ENHANCEMENT.ifEnabled(() -> () -> {
			for(int slot = 0; slot < input.method_59983(); slot++) {
				class_1799 itemStack = input.method_59984(slot);

				if(ExplosiveEnhancementCompat.FIREBALL_INGREDIENT.method_8093(itemStack)) {
					itemStack2.method_57379(FireworkFrenzyDataComponents.FIREBALL.get(), true);
					break;
				}
			}
		});
	}
}
