package dev.cammiescorner.fireworkfrenzy.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.cammiescorner.fireworkfrenzy.data.FireworkFrenzyEnchantments;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyComponents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
	@Shadow protected class_1799 useItem;

	private LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
		super(entityType, level);
		throw new UnsupportedOperationException();
	}

	@ModifyExpressionValue(method = "releaseUsingItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;useOnRelease()Z"))
	private boolean handleAirstrike(boolean original) {
		if(this.useItem.method_7909() instanceof class_1764) {
			var component = FireworkFrenzyComponents.BLAST_JUMPER.getNullable(this);

			if(component != null && component.isBlastJumping() && FireworkFrenzyEnchantments.hasAirStrike(this.method_56673(), this.useItem))
				return false;
		}

		return original;
	}

	@ModifyExpressionValue(method = "updateUsingItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;useOnRelease()Z"))
	private boolean handleUpdateUsingItemAirstrike(boolean original, class_1799 stack) {
		if(stack.method_7909() instanceof class_1764) {
			var component = FireworkFrenzyComponents.BLAST_JUMPER.getNullable(this);

			if(component != null && component.isBlastJumping() && FireworkFrenzyEnchantments.hasAirStrike(this.method_56673(), this.useItem))
				return false;
		}

		return original;
	}
}
