package dev.cammiescorner.fireworkfrenzy.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.cammiescorner.fireworkfrenzy.FireworkFrenzyConfig;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyComponents;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1657.class)
public abstract class PlayerMixin extends class_1309 {
	private PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
		super(entityType, level);
		throw new UnsupportedOperationException();
	}

	@ModifyReturnValue(method = "getFlyingSpeed", at = @At("RETURN"))
	public float airSpeed(float original) {
		if(this.getComponent(FireworkFrenzyComponents.BLAST_JUMPER).isBlastJumping())
			return original * FireworkFrenzyConfig.airStrafeSpeedMultiplier;

		return original;
	}
}
