/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.fireworkfrenzy.component;

import dev.cammiescorner.fireworkfrenzy.FireworkFrenzyConfig;
import dev.cammiescorner.fireworkfrenzy.advancement.criterion.MultiJumpTrigger;
import dev.cammiescorner.fireworkfrenzy.client.FireworkFrenzyClient;
import dev.cammiescorner.fireworkfrenzy.component.BlastJumper;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyComponents;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyCriteriaTriggers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class PlayerBlastJumper
implements BlastJumper,
AutoSyncedComponent,
ServerTickingComponent,
CommonTickingComponent {
    private static final int MAX_TIME_ON_GROUND = 100;
    private final class_1657 player;
    private boolean blastJumping = false;
    private int timeOnGround = 0;
    private int consecutiveJumps = 0;

    public PlayerBlastJumper(class_1657 player) {
        this.player = player;
    }

    @Override
    public class_1297 getEntity() {
        return this.player;
    }

    @Override
    public boolean isBlastJumping() {
        return this.blastJumping;
    }

    @Override
    public void setBlastJumping(boolean blastJumping) {
        this.blastJumping = blastJumping;
        if (blastJumping) {
            ++this.consecutiveJumps;
            class_1657 class_16572 = this.player;
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                ((MultiJumpTrigger)((Object)FireworkFrenzyCriteriaTriggers.CONSECUTIVE_BLAST_JUMPS.get())).trigger(serverPlayer, this.consecutiveJumps);
            }
        }
    }

    @Override
    public int getTimeOnGround() {
        return this.timeOnGround;
    }

    @Override
    public void setTimeOnGround(int timeOnGround) {
        this.timeOnGround = class_3532.method_15340((int)timeOnGround, (int)0, (int)100);
    }

    @Environment(value=EnvType.CLIENT)
    public void applySyncPacket(class_9129 buf) {
        boolean previous = this.isBlastJumping();
        super.applySyncPacket(buf);
        if (!previous && this.isBlastJumping() && this.player.method_37908().method_8608()) {
            FireworkFrenzyClient.playBlastSound(this.player);
        }
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.blastJumping = tag.method_10577("blastJumping");
        this.timeOnGround = tag.method_10550("timeOnGround");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10556("blastJumping", this.blastJumping);
        tag.method_10569("timeOnGround", this.timeOnGround);
    }

    public void tick() {
        if (this.isBlastJumping()) {
            if (this.player.method_24828() || this.player.method_5869()) {
                this.setTimeOnGround(this.timeOnGround + 1);
                if (this.consecutiveJumps > 0) {
                    this.consecutiveJumps = 0;
                    this.sync();
                }
            }
            if (this.getTimeOnGround() > 2 || this.player.method_5765() || FireworkFrenzyConfig.elytraCancelsRocketJumping && this.player.method_6128() || !this.player.method_5805() || this.player.method_7325() || this.player.method_31549().field_7479) {
                this.setBlastJumping(false);
                this.sync();
            }
        } else {
            this.timeOnGround = 0;
        }
    }

    @Override
    public void sync() {
        FireworkFrenzyComponents.BLAST_JUMPER.sync((Object)this.player);
    }
}

