/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.fireworkfrenzy.datagen.client;

import dev.cammiescorner.fireworkfrenzy.data.FireworkFrenzyAdvancements;
import dev.cammiescorner.fireworkfrenzy.data.FireworkFrenzyDamageTypes;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyEntityTypes;
import dev.upcraft.sparkweave.api.datagen.ContextAwarePackOutput;
import dev.upcraft.sparkweave.api.datagen.TranslationBuilder;
import dev.upcraft.sparkweave.api.datagen.provider.SparkweaveLanguageProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;

public class FireworkFrenzyEnglishLanguageProvider
extends SparkweaveLanguageProvider {
    public FireworkFrenzyEnglishLanguageProvider(ContextAwarePackOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture, "en_us");
    }

    public void generateTranslations(class_7225.class_7874 registries, TranslationBuilder builder) {
        FireworkFrenzyEnglishLanguageProvider.advancement(builder, FireworkFrenzyAdvancements.SONIC_BOOM, "Sonic Boom", "Through blast jumping, accelerate to the speed of sound (...or thereabouts)");
        FireworkFrenzyEnglishLanguageProvider.advancement(builder, FireworkFrenzyAdvancements.THE_FLOOR_IS_LAVA, "The floor is Lava", "Perform 6 consecutive blast jumps without touching the ground");
        FireworkFrenzyEnglishLanguageProvider.damageType(builder, FireworkFrenzyDamageTypes.DAMAGE_CLOUD, "%s got blown up", "%s got blown up by %s", "%s got blown up by %s using %s");
        builder.entity(FireworkFrenzyEntityTypes.DAMAGE_CLOUD, "Damage Cloud");
        builder.add("tooltip.fireworkfrenzy.rocket_damage_base", "Damage: %s");
        builder.add("tooltip.fireworkfrenzy.rocket_damage_players", "Damage against Players: %s");
        builder.add("tooltip.fireworkfrenzy.rocket_has_fireball", "+Fireball");
        builder.add("config.fireworkfrenzy.crossbow_charge_time", "Time it takes for the Crossbow to load");
        builder.add("config.fireworkfrenzy.quick_charge_modifier", "Ticks per level quick charge removes from pull time");
        builder.add("config.fireworkfrenzy.airstrike_jumping_charge_time", "Air Strike charge time while rocket jumping");
        builder.add("config.fireworkfrenzy.airstrike_grounded_charge_time", "Air Strike charge time while grounded");
        builder.add("config.fireworkfrenzy.airstrike_damage_multiplier", "Air Strike damage multiplier while rocket jumping");
        builder.add("config.fireworkfrenzy.mob_damage", "Base firework rocket damage against mobs");
        builder.add("config.fireworkfrenzy.player_damage", "Base firework rocket damage against players");
        builder.add("config.fireworkfrenzy.fireball_damage_bonus", "Extra damage added by a fire charge (Explosive Enhancement Mod Required)");
        builder.add("config.fireworkfrenzy.burst_disable_shield_chance", "Chance for Burst fireworks to disable shields");
        builder.add("config.fireworkfrenzy.allow_rocket_jumping", "Allow rocket jumping");
        builder.add("config.fireworkfrenzy.rocket_jump_knockback_multiplier", "Rocket jump knockback multiplier");
        builder.add("config.fireworkfrenzy.default_knockback_multiplier", "Other entity knockback multiplier");
        builder.add("config.fireworkfrenzy.air_strafe_speed_multiplier", "Rocket jumping air strafe speed multiplier");
        builder.add("config.fireworkfrenzy.elytra_cancels_rocket_jumping", "Elytra flight cancels rocket jumping");
        builder.add("config.fireworkfrenzy.boost_cancels_rocket_jumping", "Boosting while elytra flying cancels rocket jumping");
        builder.add("config.fireworkfrenzy.crossbow_allow_infinity_enchantment", "Crossbows can have the Infinity enchantment");
        builder.add("config.fireworkfrenzy.infinity_enchantment_affects_rockets", "Infinity works on firework rockets");
        builder.add("config.fireworkfrenzy.crossbow_use_rockets_from_inventory", "Crossbows use firework rockets from your whole inventory");
        builder.add("config.fireworkfrenzy.rockets_have_damage_falloff", "Firework rockets have damage falloff");
        builder.add("config.fireworkfrenzy.rockets_damage_falloff_per_meter", "Damage falloff per meter from shooter");
        builder.add("config.fireworkfrenzy.rocket_damage_falloff_min_multiplier", "Minimum percentage of damage dealt at maximum falloff");
        builder.add("config.fireworkfrenzy.rocket_damage_falloff_start_distance", "Minimum distance away for damage falloff to apply");
        builder.add("config.fireworkfrenzy.show_firework_damage_tooltip", "Show damage tooltip for Firework Rocket items");
    }

    private static void damageType(TranslationBuilder builder, class_5321<class_8110> damageType, String message, @Nullable String killedByPlayer, @Nullable String killedWithItem) {
        String baseKey = class_156.method_646((String)"death.attack", (class_2960)damageType.method_29177());
        builder.add(baseKey, message);
        if (killedByPlayer != null) {
            builder.add(baseKey + ".player", killedByPlayer);
        }
        if (killedWithItem != null) {
            builder.add(baseKey + ".item", killedWithItem);
        }
    }

    private static void advancement(TranslationBuilder builder, class_2960 advancementId, String title, @Nullable String description) {
        String prefix = class_156.method_646((String)"advancements", (class_2960)advancementId);
        builder.add(prefix + ".title", title);
        if (description != null) {
            builder.add(prefix + ".description", description);
        }
    }
}

