/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.fireworkfrenzy.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.cammiescorner.fireworkfrenzy.FireworkFrenzyConfig;
import dev.cammiescorner.fireworkfrenzy.advancement.criterion.DoBlastJumpTrigger;
import dev.cammiescorner.fireworkfrenzy.compat.ExplosiveEnhancementCompat;
import dev.cammiescorner.fireworkfrenzy.compat.FireworkFrenzyCompat;
import dev.cammiescorner.fireworkfrenzy.component.BlastJumper;
import dev.cammiescorner.fireworkfrenzy.data.FireworkFrenzyEnchantments;
import dev.cammiescorner.fireworkfrenzy.entities.DamageCloudEntity;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyComponents;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyCriteriaTriggers;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyDataComponents;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyEntityTypes;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_3222;
import net.minecraft.class_3856;
import net.minecraft.class_3966;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9381;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1671.class})
public abstract class FireworkRocketEntityMixin
extends class_1676
implements class_3856 {
    @Unique
    private class_1309 directTarget;
    @Shadow
    @Final
    private static class_2940<class_1799> field_7614;
    @Shadow
    @Nullable
    private class_1309 field_7616;
    @Shadow
    private int field_7612;

    @Shadow
    protected abstract boolean method_20308();

    @Shadow
    protected abstract List<class_9283> method_57318();

    @Shadow
    public abstract class_1799 method_7495();

    private FireworkRocketEntityMixin(class_1299<? extends class_1676> entityType, class_1937 level) {
        super(entityType, level);
        throw new UnsupportedOperationException();
    }

    @Inject(method={"<init>(Lnet/minecraft/class_1937;DDDLnet/minecraft/class_1799;)V"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    void noRandomFuse(class_1937 level, double x, double y, double z, class_1799 stack, CallbackInfo ci, int i) {
        this.method_18800(0.0, 0.05, 0.0);
        if (FireworkFrenzyEnchantments.hasFixedFuse(this.method_56673(), (class_1799)this.field_6011.method_12789(field_7614))) {
            this.field_7612 = 10 * i + 6;
        }
    }

    @ModifyArg(method={"method_7475()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_238;method_1014(D)Lnet/minecraft/class_238;"))
    private double blastRadius(double original, @Share(value="blastSize") LocalFloatRef blastSize, @Share(value="knockbackAmount") LocalFloatRef knockbackAmountRef, @Share(value="glowingDuration") LocalIntRef glowingDurationRef) {
        class_9284 data = (class_9284)((class_1799)this.field_6011.method_12789(field_7614)).method_57824(class_9334.field_49616);
        EnumSet<class_9283.class_1782> types = EnumSet.noneOf(class_9283.class_1782.class);
        int glowingDuration = 0;
        float knockbackAmount = 1.0f;
        if (data != null) {
            for (class_9283 explosion : data.comp_2392()) {
                types.add(explosion.comp_2386());
                if (explosion.comp_2389()) {
                    knockbackAmount += 0.1f;
                }
                if (!explosion.comp_2390()) continue;
                glowingDuration += 20;
            }
        }
        knockbackAmountRef.set(knockbackAmount);
        glowingDurationRef.set(glowingDuration);
        if (types.contains(class_9283.class_1782.field_7977)) {
            blastSize.set(5.0f);
        } else if (types.contains(class_9283.class_1782.field_7973)) {
            blastSize.set(5.0f);
        } else {
            blastSize.set(3.0f);
        }
        return blastSize.get();
    }

    @Inject(method={"method_7475()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_5643(Lnet/minecraft/class_1282;F)Z", ordinal=1)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void explodePostDamage(CallbackInfo ci, float damage, List<class_9283> list, double d, class_243 vec3, List<class_1309> list2, Iterator<class_1309> var7, class_1309 target, boolean bl, float g, @Share(value="target") LocalRef<class_1309> targetRef, @Share(value="blastSize") LocalFloatRef blastSize, @Share(value="knockbackAmount") LocalFloatRef knockbackAmount, @Share(value="glowingDuration") LocalIntRef glowingDuration) {
        class_243 adjustedTargetPos;
        class_243 adjustedPos;
        class_3966 hitResult;
        class_1282 source;
        targetRef.set((Object)target);
        if (this.method_20308() && !target.method_6061(source = this.method_48923().method_48805((class_1671)this, this.method_24921())) && (hitResult = class_1675.method_18075((class_1297)this, (class_243)(adjustedPos = this.method_19538().method_1031(0.0, (double)this.method_17682() / 2.0, 0.0)), (class_243)(adjustedTargetPos = target.method_19538().method_1031(0.0, (double)target.method_17682() / 2.0, 0.0)), (class_238)this.method_5829().method_1014((double)blastSize.get()), entity -> entity == target, (double)adjustedPos.method_1025(adjustedTargetPos))) != null && hitResult.method_17783() == class_239.class_240.field_1331) {
            boolean result;
            class_1297 owner = this.method_24921();
            double distance = Math.max(1.0, hitResult.method_17784().method_1022(adjustedPos));
            float fireworkDamage = (target instanceof class_1657 ? FireworkFrenzyConfig.playerDamage : FireworkFrenzyConfig.mobDamage) * (float)list.size() + ((Boolean)this.method_7495().method_57825((class_9331)FireworkFrenzyDataComponents.FIREBALL.get(), (Object)false) != false ? FireworkFrenzyConfig.fireballDamageBonus : 0.0f);
            if (FireworkFrenzyConfig.rocketsHaveDamageFalloff && owner != null) {
                fireworkDamage = Math.max(FireworkFrenzyConfig.minFalloffMultiplier * fireworkDamage, fireworkDamage - Math.max(0.0f, this.method_5739(owner) - FireworkFrenzyConfig.rocketDamageFalloffStartDistance) * FireworkFrenzyConfig.rocketDamageFalloffPerMeter);
            }
            if (this.method_59958() != null && FireworkFrenzyEnchantments.hasAirStrike(this.method_56673(), this.method_59958()) && owner != null && FireworkFrenzyComponents.BLAST_JUMPER.maybeGet((Object)owner).map(BlastJumper::isBlastJumping).orElse(false).booleanValue()) {
                fireworkDamage *= FireworkFrenzyConfig.airStrikeDamageMultiplier;
            }
            if (target != this.directTarget) {
                fireworkDamage = Math.max(1.0f, fireworkDamage / (float)distance);
            }
            if ((result = target.method_5643(source, fireworkDamage)) && glowingDuration.get() > 0) {
                target.method_6092(new class_1293(class_1294.field_5912, glowingDuration.get(), 0, false, false));
            }
            if (FireworkFrenzyConfig.allowRocketJumping) {
                double multiplier = (double)(list.size() + ((Boolean)this.method_7495().method_57825((class_9331)FireworkFrenzyDataComponents.FIREBALL.get(), (Object)false) != false ? 1 : 0)) * 0.3 * (double)knockbackAmount.get() * (target == owner ? FireworkFrenzyConfig.rocketJumpKnockbackMultiplier : FireworkFrenzyConfig.defaultKnockbackMultiplier);
                class_243 targetVelocity = target.method_18798();
                targetVelocity = new class_243(targetVelocity.method_10216(), Math.max(1.0, Math.abs(targetVelocity.method_10214())), targetVelocity.method_10215()).method_1021(multiplier / distance);
                target.method_18799(targetVelocity);
                target.field_6037 = true;
                if (target instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)target;
                    ((DoBlastJumpTrigger)((Object)FireworkFrenzyCriteriaTriggers.BLAST_JUMP.get())).trigger(serverPlayer, targetVelocity.method_1033());
                }
            }
        }
        if (FireworkFrenzyConfig.allowRocketJumping) {
            FireworkFrenzyComponents.BLAST_JUMPER.maybeGet((Object)target).ifPresent(component -> {
                component.setTimeOnGround(0);
                component.setBlastJumping(true);
                component.sync();
            });
        }
    }

    @Inject(method={"method_7475()V"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void spawnPotionCloud(CallbackInfo info, @Share(value="target") LocalRef<class_1309> targetRef, @Share(value="blastSize") LocalFloatRef blastSize) {
        class_1657 player;
        Object object;
        DamageCloudEntity cloud;
        class_1799 stack = (class_1799)this.field_6011.method_12789(field_7614);
        if (stack.method_7960()) {
            return;
        }
        class_9284 data = (class_9284)stack.method_57824(class_9334.field_49616);
        EnumSet<class_9283.class_1782> types = EnumSet.noneOf(class_9283.class_1782.class);
        for (class_9283 explosion : data.comp_2392()) {
            types.add(explosion.comp_2386());
        }
        if (types.contains(class_9283.class_1782.field_7973) && (cloud = (DamageCloudEntity)((class_1299)FireworkFrenzyEntityTypes.DAMAGE_CLOUD.get()).method_5883(this.method_37908())) != null) {
            cloud.method_5603(blastSize.get());
            cloud.method_5607(this.field_7616);
            cloud.method_5604(200);
            cloud.method_5608((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)16306794));
            cloud.method_33574(this.method_19538().method_1031(0.0, (double)(-cloud.method_5599()), 0.0));
            this.method_37908().method_8649((class_1297)cloud);
        }
        if (types.contains(class_9283.class_1782.field_7970) && (object = targetRef.get()) instanceof class_1657 && (player = (class_1657)object).method_6039() && this.field_5974.method_43057() < FireworkFrenzyConfig.burstDisableShieldChance) {
            player.method_7357().method_7906(class_1802.field_8255, 50);
            player.method_6021();
            this.method_37908().method_8421((class_1297)this, (byte)30);
        }
    }

    @Inject(method={"method_7454(Lnet/minecraft/class_3966;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1671;method_16830()V")})
    public void onDirectHit(class_3966 entityHitResult, CallbackInfo info) {
        class_1297 class_12972 = entityHitResult.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 target;
            this.directTarget = target = (class_1309)class_12972;
        }
    }

    @WrapWithCondition(method={"method_5711(B)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1937;method_8547(DDDDDDLjava/util/List;)V")})
    public boolean inhibitFireworkParticles(class_1937 instance, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, List<class_9283> explosions) {
        return !FireworkFrenzyCompat.EXPLOSIVE_ENHANCEMENT.isEnabled();
    }

    @Inject(method={"method_5711(B)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1937;method_8547(DDDDDDLjava/util/List;)V")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void explosiveEnhancement(byte id, CallbackInfo ci, class_243 vec3) {
        if (FireworkFrenzyCompat.EXPLOSIVE_ENHANCEMENT.isEnabled()) {
            if (((Boolean)this.method_7495().method_57825((class_9331)FireworkFrenzyDataComponents.FIREBALL.get(), (Object)false)).booleanValue()) {
                ExplosiveEnhancementCompat.spawnEnhancedBooms(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), 1.25f);
            } else {
                this.method_37908().method_8547(this.method_23317(), this.method_23318(), this.method_23321(), vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), this.method_57318());
            }
        }
    }

    @ModifyArg(method={"method_7475()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_5643(Lnet/minecraft/class_1282;F)Z", ordinal=0))
    public float noSelfDamage(class_1282 source, float amount) {
        return 0.0f;
    }

    @ModifyArg(method={"method_7475()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_5643(Lnet/minecraft/class_1282;F)Z", ordinal=1))
    public float noCrossbowDamage(class_1282 source, float amount) {
        return 0.0f;
    }
}

