/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.config.source.jankson;

import blue.endless.jankson.Comment;
import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonNull;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import blue.endless.jankson.annotation.SerializedName;
import blue.endless.jankson.annotation.Serializer;
import blue.endless.jankson.api.DeserializationException;
import blue.endless.jankson.api.DeserializerFunction;
import blue.endless.jankson.impl.POJODeserializer;
import blue.endless.jankson.impl.serializer.DeserializerFunctionPool;
import blue.endless.jankson.magic.TypeMagic;
import com.awakenedredstone.autowhitelist.config.source.AnnotationParserException;
import com.awakenedredstone.autowhitelist.config.source.annotation.NameFormat;
import com.awakenedredstone.autowhitelist.config.source.annotation.SkipNameFormat;
import com.awakenedredstone.autowhitelist.mixin.jankson.POJODeserializerAccessor;
import com.google.common.base.CaseFormat;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Marshaller
implements blue.endless.jankson.api.Marshaller {
    public static final Logger LOGGER = LoggerFactory.getLogger(Marshaller.class);
    private static final Marshaller INSTANCE = new Marshaller();
    private final Map<Class<?>, Function<Object, ?>> primitiveMarshallers = new HashMap();
    protected final Map<Class<?>, Function<JsonObject, ?>> typeAdapters = new HashMap();
    private final Map<Class<?>, BiFunction<Object, blue.endless.jankson.api.Marshaller, JsonElement>> serializers = new HashMap();
    private final Map<Class<?>, DeserializerFunctionPool<?>> deserializers = new HashMap();
    private final Map<Class<?>, Supplier<?>> typeFactories = new HashMap();
    private final Map<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation, ?>> annotationProcessors = new HashMap();

    public static blue.endless.jankson.api.Marshaller getFallback() {
        return INSTANCE;
    }

    public <T> void register(Class<T> clazz, Function<Object, T> marshaller) {
        this.primitiveMarshallers.put(clazz, marshaller);
    }

    public <T> void registerTypeAdapter(Class<T> clazz, Function<JsonObject, T> adapter) {
        this.typeAdapters.put(clazz, adapter);
    }

    public <T> void registerSerializer(Class<T> clazz, Function<T, JsonElement> serializer) {
        this.serializers.put(clazz, (it, marshaller) -> (JsonElement)serializer.apply(it));
    }

    public <T> void registerSerializer(Class<T> clazz, BiFunction<T, blue.endless.jankson.api.Marshaller, JsonElement> serializer) {
        this.serializers.put(clazz, serializer);
    }

    public <T> void registerTypeFactory(Class<T> clazz, Supplier<T> supplier) {
        this.typeFactories.put(clazz, supplier);
    }

    public <A, B> void registerDeserializer(Class<A> sourceClass, Class<B> targetClass, DeserializerFunction<A, B> function) {
        DeserializerFunctionPool pool = this.deserializers.get(targetClass);
        if (pool == null) {
            pool = new DeserializerFunctionPool(targetClass);
            this.deserializers.put(targetClass, pool);
        }
        pool.registerUnsafe(sourceClass, function);
    }

    public Marshaller() {
        this.register(Void.class, it -> null);
        this.register(String.class, Object::toString);
        this.register(Byte.class, it -> it instanceof Number ? Byte.valueOf(((Number)it).byteValue()) : null);
        this.register(Character.class, it -> Character.valueOf(it instanceof Number ? (char)((Number)it).shortValue() : it.toString().charAt(0)));
        this.register(Short.class, it -> it instanceof Number ? Short.valueOf(((Number)it).shortValue()) : null);
        this.register(Integer.class, it -> it instanceof Number ? Integer.valueOf(((Number)it).intValue()) : null);
        this.register(Long.class, it -> it instanceof Number ? Long.valueOf(((Number)it).longValue()) : null);
        this.register(Float.class, it -> it instanceof Number ? Float.valueOf(((Number)it).floatValue()) : null);
        this.register(Double.class, it -> it instanceof Number ? Double.valueOf(((Number)it).doubleValue()) : null);
        this.register(Boolean.class, it -> it instanceof Boolean ? (Boolean)it : null);
        this.register(Void.TYPE, it -> null);
        this.register(Byte.TYPE, it -> it instanceof Number ? Byte.valueOf(((Number)it).byteValue()) : null);
        this.register(Character.TYPE, it -> Character.valueOf(it instanceof Number ? (char)((Number)it).shortValue() : it.toString().charAt(0)));
        this.register(Short.TYPE, it -> it instanceof Number ? Short.valueOf(((Number)it).shortValue()) : null);
        this.register(Integer.TYPE, it -> it instanceof Number ? Integer.valueOf(((Number)it).intValue()) : null);
        this.register(Long.TYPE, it -> it instanceof Number ? Long.valueOf(((Number)it).longValue()) : null);
        this.register(Float.TYPE, it -> it instanceof Number ? Float.valueOf(((Number)it).floatValue()) : null);
        this.register(Double.TYPE, it -> it instanceof Number ? Double.valueOf(((Number)it).doubleValue()) : null);
        this.register(Boolean.TYPE, it -> it instanceof Boolean ? (Boolean)it : null);
        this.registerSerializer(Void.class, (T it) -> JsonNull.INSTANCE);
        this.registerSerializer(Character.class, (T it) -> new JsonPrimitive((Object)("" + it)));
        this.registerSerializer(String.class, JsonPrimitive::new);
        this.registerSerializer(Byte.class, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Short.class, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Integer.class, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Long.class, JsonPrimitive::new);
        this.registerSerializer(Float.class, (T it) -> new JsonPrimitive((Object)it.floatValue()));
        this.registerSerializer(Double.class, JsonPrimitive::new);
        this.registerSerializer(Boolean.class, JsonPrimitive::new);
        this.registerSerializer(Void.TYPE, (T it) -> JsonNull.INSTANCE);
        this.registerSerializer(Character.TYPE, (T it) -> new JsonPrimitive((Object)("" + it)));
        this.registerSerializer(Byte.TYPE, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Short.TYPE, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Integer.TYPE, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Long.TYPE, JsonPrimitive::new);
        this.registerSerializer(Float.TYPE, (T it) -> new JsonPrimitive((Object)it.floatValue()));
        this.registerSerializer(Double.TYPE, JsonPrimitive::new);
        this.registerSerializer(Boolean.TYPE, JsonPrimitive::new);
        this.registerSerializer(UUID.class, (T uuid, blue.endless.jankson.api.Marshaller marshaller) -> {
            JsonArray array = new JsonArray();
            array.add((JsonElement)new JsonPrimitive((Object)uuid.getMostSignificantBits()));
            array.add((JsonElement)new JsonPrimitive((Object)uuid.getLeastSignificantBits()));
            return array;
        });
        this.registerDeserializer(JsonArray.class, UUID.class, (json, m) -> new UUID(json.getLong(0, 0L), json.getLong(1, 0L)));
    }

    @Nullable
    public <T> T marshall(Type type, JsonElement elem) {
        if (elem == null) {
            return null;
        }
        if (elem == JsonNull.INSTANCE) {
            return null;
        }
        if (type instanceof Class) {
            try {
                return this.marshall((Class)type, elem);
            }
            catch (ClassCastException t) {
                return null;
            }
        }
        if (type instanceof ParameterizedType) {
            try {
                Class clazz = TypeMagic.classForType((Type)type);
                return this.marshall(clazz, elem);
            }
            catch (ClassCastException t) {
                return null;
            }
        }
        return null;
    }

    public <T> T marshall(Class<T> clazz, JsonElement elem) {
        try {
            return this.marshall(clazz, elem, false);
        }
        catch (Throwable t) {
            LOGGER.debug("Failed to parse JSON into class {}", (Object)clazz.getCanonicalName(), (Object)t);
            return null;
        }
    }

    public <T> T marshallCarefully(Class<T> clazz, JsonElement elem) throws DeserializationException {
        return this.marshall(clazz, elem, true);
    }

    @Nullable
    public <T> T marshall(Class<T> clazz, JsonElement elem, boolean failFast) throws DeserializationException {
        if (elem == null) {
            return null;
        }
        if (elem == JsonNull.INSTANCE) {
            return null;
        }
        if (clazz.isAssignableFrom(elem.getClass())) {
            return (T)elem;
        }
        Object pool = this.deserializers.get(clazz);
        if (pool != null) {
            try {
                return (T)pool.apply(elem, (blue.endless.jankson.api.Marshaller)this);
            }
            catch (DeserializerFunctionPool.FunctionMatchFailedException functionMatchFailedException) {
                // empty catch block
            }
        }
        pool = POJODeserializerAccessor.callDeserializersFor(clazz);
        try {
            Object poolResult = pool.apply(elem, (blue.endless.jankson.api.Marshaller)this);
            return (T)poolResult;
        }
        catch (DeserializerFunctionPool.FunctionMatchFailedException functionMatchFailedException) {
            if (Enum.class.isAssignableFrom(clazz)) {
                if (!(elem instanceof JsonPrimitive)) {
                    return null;
                }
                String name = ((JsonPrimitive)elem).getValue().toString();
                T[] constants = clazz.getEnumConstants();
                if (constants == null) {
                    return null;
                }
                for (T t : constants) {
                    if (((Enum)t).name().equals(name)) {
                        return t;
                    }
                    if (!((Enum)t).name().equals(name.toUpperCase())) continue;
                    return t;
                }
            }
            if (clazz.equals(String.class)) {
                if (elem instanceof JsonObject) {
                    return (T)elem.toJson(false, false);
                }
                if (elem instanceof JsonArray) {
                    return (T)elem.toJson(false, false);
                }
                if (elem instanceof JsonPrimitive) {
                    return (T)((JsonPrimitive)elem).asString();
                }
                if (elem instanceof JsonNull) {
                    return (T)"null";
                }
                if (failFast) {
                    throw new DeserializationException("Encountered unexpected JsonElement type while deserializing to string: " + elem.getClass().getCanonicalName());
                }
                LOGGER.debug("Encountered unexpected JsonElement type while deserializing to string: {}", (Object)elem.getClass().getCanonicalName());
                return null;
            }
            if (elem instanceof JsonPrimitive) {
                Function<Object, ?> func = this.primitiveMarshallers.get(clazz);
                if (func != null) {
                    return (T)func.apply(((JsonPrimitive)elem).getValue());
                }
                if (failFast) {
                    throw new DeserializationException("Don't know how to unpack value '" + elem.toString() + "' into target type '" + clazz.getCanonicalName() + "'");
                }
                LOGGER.debug("Don't know how to unpack value '{}' into target type '{}'", (Object)elem.toString(), (Object)clazz.getCanonicalName());
                return null;
            }
            if (elem instanceof JsonObject) {
                Object result;
                JsonObject obj = (JsonObject)elem;
                if (clazz.isPrimitive()) {
                    throw new DeserializationException("Can't marshall json object into primitive type " + clazz.getCanonicalName());
                }
                if (JsonPrimitive.class.isAssignableFrom(clazz)) {
                    if (failFast) {
                        throw new DeserializationException("Can't marshall json object into a json primitive");
                    }
                    LOGGER.debug("Can't marshall json object into a json primitive");
                    return null;
                }
                obj.setMarshaller((blue.endless.jankson.api.Marshaller)this);
                if (this.typeAdapters.containsKey(clazz)) {
                    return (T)this.typeAdapters.get(clazz).apply((JsonObject)elem);
                }
                if (this.typeFactories.containsKey(clazz)) {
                    result = this.typeFactories.get(clazz).get();
                    try {
                        POJODeserializer.unpackObject((Object)result, (JsonObject)obj, (boolean)failFast);
                        return (T)result;
                    }
                    catch (Throwable t) {
                        if (failFast) {
                            throw t;
                        }
                        LOGGER.debug("Failed to parse JSON into class {} [typeFactories]", (Object)clazz.getCanonicalName(), (Object)t);
                        return null;
                    }
                }
                try {
                    result = TypeMagic.createAndCast(clazz, (boolean)failFast);
                    Object resultDefault = TypeMagic.createAndCast(clazz, (boolean)failFast);
                    POJODeserializer.unpackObject((Object)result, (JsonObject)obj, (boolean)failFast);
                    try {
                        this.parseAnnotations(clazz, result, resultDefault);
                    }
                    catch (Throwable t) {
                        if (failFast) {
                            throw new AnnotationParserException(t);
                        }
                        LOGGER.error("Could not parse annotations of the provided JSON", t);
                    }
                    return (T)result;
                }
                catch (Throwable t) {
                    if (failFast) {
                        throw t;
                    }
                    LOGGER.debug("Failed to parse JSON into class {} [typeFactories$else]", (Object)clazz.getCanonicalName(), (Object)t);
                    return null;
                }
            }
            if (elem instanceof JsonArray) {
                if (clazz.isPrimitive()) {
                    LOGGER.debug("Failed to parse JSON into class {} [elem instanceof JsonArray]", (Object)clazz.getCanonicalName());
                    return null;
                }
                if (clazz.isArray()) {
                    Class<?> componentType = clazz.getComponentType();
                    JsonArray array = (JsonArray)elem;
                    Object result = Array.newInstance(componentType, array.size());
                    for (int i = 0; i < array.size(); ++i) {
                        Array.set(result, i, this.marshall(componentType, array.get(i)));
                    }
                    return (T)result;
                }
            }
            LOGGER.debug("Failed to parse JSON into class {} [END]", (Object)clazz.getCanonicalName());
            return null;
        }
    }

    public JsonElement serialize(Object obj) {
        Comment comment;
        NameFormat formatter;
        SerializedName nameAnnotation;
        SkipNameFormat skipNameFormat;
        NameFormat nameFormat;
        String name;
        Object child2;
        JsonElement parsed;
        JsonArray array;
        if (obj == null) {
            return JsonNull.INSTANCE;
        }
        BiFunction<Object, blue.endless.jankson.api.Marshaller, JsonElement> serializer = this.serializers.get(obj.getClass());
        if (serializer != null) {
            JsonElement result = serializer.apply(obj, this);
            if (result instanceof JsonObject) {
                ((JsonObject)result).setMarshaller((blue.endless.jankson.api.Marshaller)this);
            }
            if (result instanceof JsonArray) {
                ((JsonArray)result).setMarshaller((blue.endless.jankson.api.Marshaller)this);
            }
            return result;
        }
        for (Map.Entry<Class<?>, BiFunction<Object, blue.endless.jankson.api.Marshaller, JsonElement>> entry : this.serializers.entrySet()) {
            if (!entry.getKey().isAssignableFrom(obj.getClass())) continue;
            JsonElement result = entry.getValue().apply(obj, this);
            if (result instanceof JsonObject) {
                ((JsonObject)result).setMarshaller((blue.endless.jankson.api.Marshaller)this);
            }
            if (result instanceof JsonArray) {
                ((JsonArray)result).setMarshaller((blue.endless.jankson.api.Marshaller)this);
            }
            return result;
        }
        for (Method m : obj.getClass().getDeclaredMethods()) {
            Class<?> clazz;
            if (!m.isAnnotationPresent(Serializer.class) || Modifier.isStatic(m.getModifiers()) || !JsonElement.class.isAssignableFrom(clazz = m.getReturnType())) continue;
            Parameter[] params = m.getParameters();
            if (params.length == 0) {
                try {
                    boolean access = m.canAccess(obj);
                    if (!access) {
                        m.setAccessible(true);
                    }
                    JsonElement result = (JsonElement)m.invoke(obj, new Object[0]);
                    if (!access) {
                        m.setAccessible(false);
                    }
                    if (result instanceof JsonObject) {
                        ((JsonObject)result).setMarshaller((blue.endless.jankson.api.Marshaller)this);
                    }
                    if (result instanceof JsonArray) {
                        ((JsonArray)result).setMarshaller((blue.endless.jankson.api.Marshaller)this);
                    }
                    return result;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return JsonNull.INSTANCE;
                }
            }
            if (params.length != 1 || !blue.endless.jankson.api.Marshaller.class.isAssignableFrom(params[0].getType())) continue;
            try {
                boolean access = m.canAccess(obj);
                if (!access) {
                    m.setAccessible(true);
                }
                JsonElement result = (JsonElement)m.invoke(obj, this);
                if (!access) {
                    m.setAccessible(false);
                }
                if (result instanceof JsonObject) {
                    ((JsonObject)result).setMarshaller((blue.endless.jankson.api.Marshaller)this);
                }
                if (result instanceof JsonArray) {
                    ((JsonArray)result).setMarshaller((blue.endless.jankson.api.Marshaller)this);
                }
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return JsonNull.INSTANCE;
            }
        }
        if (obj instanceof Enum) {
            return new JsonPrimitive((Object)((Enum)obj).name());
        }
        if (obj.getClass().isArray()) {
            array = new JsonArray();
            array.setMarshaller((blue.endless.jankson.api.Marshaller)this);
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Object elem = Array.get(obj, i);
                parsed = this.serialize(elem);
                array.add(parsed);
            }
            return array;
        }
        if (obj instanceof Collection) {
            array = new JsonArray();
            array.setMarshaller((blue.endless.jankson.api.Marshaller)this);
            for (Object elem : (Collection)obj) {
                parsed = this.serialize(elem);
                array.add(parsed);
            }
            return array;
        }
        if (obj instanceof Map) {
            JsonObject result = new JsonObject();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                String k = entry.getKey().toString();
                Object v = entry.getValue();
                result.put(k, this.serialize(v));
            }
            return result;
        }
        NameFormat defaultNameFormat = obj.getClass().getAnnotation(NameFormat.class);
        JsonObject result = new JsonObject();
        for (Field field : obj.getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                child2 = field.get(obj);
                name = field.getName();
                nameFormat = field.getAnnotation(NameFormat.class);
                skipNameFormat = field.getAnnotation(SkipNameFormat.class);
                nameAnnotation = field.getAnnotation(SerializedName.class);
                if (skipNameFormat == null && (nameFormat != null || defaultNameFormat != null) && nameAnnotation == null) {
                    formatter = nameFormat != null ? nameFormat : defaultNameFormat;
                    name = CaseFormat.LOWER_CAMEL.to(formatter.value().getCaseFormat(), name);
                }
                if (nameAnnotation != null) {
                    name = nameAnnotation.value();
                }
                if ((comment = field.getAnnotation(Comment.class)) == null) {
                    result.put(name, this.serialize(child2));
                    continue;
                }
                result.put(name, this.serialize(child2), comment.value());
            }
            catch (IllegalAccessException | IllegalArgumentException child2) {
                // empty catch block
            }
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                child2 = field.get(obj);
                name = field.getName();
                nameFormat = field.getAnnotation(NameFormat.class);
                skipNameFormat = field.getAnnotation(SkipNameFormat.class);
                nameAnnotation = field.getAnnotation(SerializedName.class);
                if (skipNameFormat == null && (nameFormat != null || defaultNameFormat != null) && nameAnnotation == null) {
                    formatter = nameFormat != null ? nameFormat : defaultNameFormat;
                    name = CaseFormat.LOWER_CAMEL.to(formatter.value().getCaseFormat(), name);
                }
                if (nameAnnotation != null) {
                    name = nameAnnotation.value();
                }
                try {
                    Object instance = TypeMagic.createAndCast(obj.getClass(), (boolean)true);
                    this.parseAnnotations(obj.getClass(), obj, instance);
                }
                catch (DeserializationException e) {
                    throw new AssertionError("Failed to create instance of " + obj.getClass().getCanonicalName(), e);
                }
                comment = field.getAnnotation(Comment.class);
                if (comment == null) {
                    result.put(name, this.serialize(child2));
                    continue;
                }
                result.put(name, this.serialize(child2), comment.value());
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected void parseAnnotations(Class<?> clazz, Object obj, Object objDefault) {
        for (Field field : clazz.getDeclaredFields()) {
            try {
                Object fieldValue = field.get(obj);
                for (Annotation annotation : field.getAnnotations()) {
                    boolean valid;
                    AnnotationProcessor<Annotation, ?> processor = this.annotationProcessors.get(annotation.annotationType());
                    if (processor == null || (valid = processor.process(annotation, fieldValue, obj.getClass(), field.getName()))) continue;
                    field.set(obj, field.get(objDefault));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public <A extends Annotation, O> void registerAnnotationProcessor(Class<A> annotation, AnnotationProcessor<A, O> processor) {
        this.annotationProcessors.put(annotation, processor);
    }

    @FunctionalInterface
    public static interface AnnotationProcessor<A extends Annotation, V> {
        public boolean process(A var1, V var2, Class<?> var3, String var4);
    }
}

