/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.entry.implementation;

import com.awakenedredstone.autowhitelist.AutoWhitelist;
import com.awakenedredstone.autowhitelist.entry.BaseEntryAction;
import com.awakenedredstone.autowhitelist.util.Stonecutter;
import com.awakenedredstone.autowhitelist.util.Texts;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedPlayerProfile;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

public class CommandEntryAction
extends BaseEntryAction {
    public static final class_2960 ID = AutoWhitelist.id("execute_command");
    public static final MapCodec<CommandEntryAction> CODEC = Stonecutter.entryCodec(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("roles").forGetter(BaseEntryAction::getRoles), (App)class_2960.field_25139.fieldOf("type").forGetter(BaseEntryAction::getType), (App)Keys.CODEC.fieldOf("execute").forGetter(command -> new Keys(command.addCommand, command.removeCommand))).apply((Applicative)instance, CommandEntryAction::new));
    private final String addCommand;
    private final String removeCommand;

    protected CommandEntryAction(List<String> roles, class_2960 type, Keys executeKeys) {
        super(type, roles);
        this.addCommand = executeKeys.onAdd();
        this.removeCommand = executeKeys.onRemove();
    }

    @Override
    public void registerUser(ExtendedPlayerProfile profile) {
        if (StringUtils.isBlank((CharSequence)this.addCommand)) {
            return;
        }
        AutoWhitelist.getServer().method_3734().method_44252(AutoWhitelist.getCommandSource(), Texts.playerPlaceholder(this.addCommand, Stonecutter.profileName(profile)).getString());
    }

    @Override
    public void removeUser(ExtendedPlayerProfile profile) {
        if (StringUtils.isBlank((CharSequence)this.removeCommand)) {
            return;
        }
        AutoWhitelist.getServer().method_3734().method_44252(AutoWhitelist.getCommandSource(), Texts.playerPlaceholder(this.removeCommand, Stonecutter.profileName(profile)).getString());
    }

    @Override
    public boolean isValid() {
        return this.checkCommand(this.addCommand.split(" ", 2)[0]) && this.checkCommand(this.removeCommand.split(" ", 2)[0]);
    }

    private boolean checkCommand(String command) {
        RootCommandNode root = AutoWhitelist.getServer().method_3734().method_9235().getRoot();
        CommandNode child = root.getChild(command);
        if (child == null && StringUtils.isNotBlank((CharSequence)command)) {
            if (command.startsWith("/")) {
                this.LOGGER.warn("You don't need a slash at the start of the command, found on command \"{}\"", (Object)command);
            }
            this.LOGGER.error("The command \"{}\" does not exist!", (Object)command);
            return false;
        }
        if (child != null && !child.canUse((Object)AutoWhitelist.getCommandSource())) {
            this.LOGGER.error("AutoWhitelist does not have enough permission to execute the command \"{}\"!", (Object)command);
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "CommandEntry{addCommand='" + this.addCommand + "', removeCommand='" + this.removeCommand + "'}";
    }

    @Override
    public boolean equals(BaseEntryAction otherEntry) {
        CommandEntryAction other = (CommandEntryAction)otherEntry;
        return Objects.equals(this.addCommand, other.addCommand) && Objects.equals(this.removeCommand, other.removeCommand);
    }

    protected record Keys(String onAdd, String onRemove) {
        public static final Codec<Keys> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("on_add").forGetter(Keys::onAdd), (App)Codec.STRING.fieldOf("on_remove").forGetter(Keys::onRemove)).apply((Applicative)instance, Keys::new));
    }
}

