/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.discord.api;

import com.awakenedredstone.autowhitelist.AutoWhitelist;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Message;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.InteractionHook;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.RestAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.messages.MessageCreateData;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.messages.MessageEditData;
import com.awakenedredstone.autowhitelist.lib.jdautils.command.SlashCommandEvent;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ReplyCallback {
    public void sendMessage(MessageCreateData var1);

    public void editMessage(MessageEditData var1);

    public static class DefaultInteractionReplyCallback
    extends InteractionReplyCallback {
        private final SlashCommandEvent event;

        public DefaultInteractionReplyCallback(SlashCommandEvent event) {
            this.event = event;
        }

        @Override
        public void sendMessage(MessageCreateData messageData) {
            if (messageData == null) {
                this.acknowledgment.set(this.acknowledge());
            } else {
                this.acknowledgment.set(CompletableFuture.completedFuture((InteractionHook)this.event.reply(messageData).setEphemeral(AutoWhitelist.CONFIG.ephemeralReplies).complete()));
            }
            ((CompletableFuture)this.acknowledgment.get()).thenAccept(message -> {
                this.originalMessage.set(message);
                Consumer hookConsumer = (Consumer)this.pendingTask.get();
                if (hookConsumer != null) {
                    hookConsumer.accept(message);
                }
            });
        }

        @Override
        public CompletableFuture<InteractionHook> acknowledge() {
            return CompletableFuture.completedFuture((InteractionHook)this.event.deferReply(AutoWhitelist.CONFIG.ephemeralReplies).complete());
        }
    }

    public static abstract class InteractionReplyCallback
    implements ReplyCallback {
        protected final AtomicReference<CompletableFuture<InteractionHook>> acknowledgment = new AtomicReference();
        public final AtomicReference<CompletableFuture<Message>> executingTask = new AtomicReference();
        protected final AtomicReference<Consumer<InteractionHook>> pendingTask = new AtomicReference();
        protected final AtomicReference<InteractionHook> originalMessage = new AtomicReference();

        @Override
        public void sendMessage(MessageCreateData messageData) {
            this.acknowledgment.set(this.acknowledge());
            this.acknowledgment.get().thenAccept(message -> {
                this.originalMessage.set((InteractionHook)message);
                Consumer<InteractionHook> hookConsumer = this.pendingTask.get();
                if (hookConsumer != null) {
                    hookConsumer.accept((InteractionHook)message);
                }
            });
        }

        protected abstract CompletableFuture<InteractionHook> acknowledge();

        @Override
        public void editMessage(MessageEditData messageData) {
            this.submitEdit(interactionHook -> interactionHook.editOriginal(messageData));
        }

        public <R extends RestAction<Message>> void submitEdit(Function<InteractionHook, R> messageFunction) {
            if (!this.acknowledgment.get().isDone()) {
                this.pendingTask.set(hook -> this.executingTask.set(CompletableFuture.completedFuture((Message)((RestAction)messageFunction.apply(this.originalMessage.get())).complete())));
            } else {
                if (this.executingTask.get() != null) {
                    this.executingTask.get().cancel(true);
                }
                this.executingTask.set(CompletableFuture.completedFuture((Message)((RestAction)messageFunction.apply(this.originalMessage.get())).complete()));
            }
        }
    }
}

