/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.lib.jdautils.commons.utils;

import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Guild;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.DiscordLocale;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.LoggerFactory;

public class TranslateUtil {
    public static final Map<DiscordLocale, Properties> LOCALES = new HashMap<DiscordLocale, Properties>();
    private static DiscordLocale DEFAULT = DiscordLocale.ENGLISH_US;

    private TranslateUtil() {
    }

    public static void setDefaultLocale(DiscordLocale locale) {
        DEFAULT = locale;
    }

    public static void addLocale(DiscordLocale locale, Properties prop) {
        LOCALES.put(locale, prop);
    }

    public static String t(Guild server, String key) {
        DiscordLocale locale = server.getLocale();
        String def = LOCALES.get((Object)DEFAULT).getProperty(key, "No translation provided");
        String translated = LOCALES.getOrDefault((Object)locale, LOCALES.get((Object)DEFAULT)).getProperty(key, def);
        if (translated.equals(def)) {
            LoggerFactory.getLogger(TranslateUtil.class).warn("No translation provided for key {} in locale {}", (Object)key, (Object)locale);
        }
        return translated;
    }

    public static String t(DiscordLocale locale, String key) {
        return LOCALES.getOrDefault((Object)locale, LOCALES.get((Object)DEFAULT)).getProperty(key, LOCALES.get((Object)DEFAULT).getProperty(key, "No translation provided"));
    }

    public static Map<DiscordLocale, String> buildLocaleMap(String key) {
        HashMap<DiscordLocale, String> locales = new HashMap<DiscordLocale, String>();
        locales.put(DEFAULT, LOCALES.get((Object)DEFAULT).getProperty(key, "No translation provided"));
        for (DiscordLocale locale : LOCALES.keySet()) {
            String translation = LOCALES.get((Object)locale).getProperty(key);
            if (translation == null) continue;
            locales.put(locale, translation);
        }
        return locales;
    }

    public static DiscordLocale getDefaultLocale() {
        return DEFAULT;
    }
}

