/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.config.source;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.api.SyntaxError;
import com.awakenedredstone.autowhitelist.Constants;
import com.awakenedredstone.autowhitelist.config.source.AnnotationParserException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"AutoWhitelist Config");
    private final Map<String, Consumer<Object>> listeners = new HashMap<String, Consumer<Object>>();
    private final Jankson interpreter;
    protected final Path fileLocation;
    protected boolean loading = false;

    public ConfigHandler(String configFile, Jankson interpreter) {
        this.fileLocation = FabricLoader.getInstance().getConfigDir().resolve(configFile + ".json5");
        this.interpreter = interpreter;
    }

    public Path getFileLocation() {
        return this.fileLocation;
    }

    public void save() {
        this.save(this.interpreter.toJson((Object)this));
    }

    protected void save(JsonElement config) {
        if (this.loading) {
            return;
        }
        try {
            if (!this.getFileLocation().getParent().toFile().exists() && !this.getFileLocation().getParent().toFile().mkdirs()) {
                LOGGER.error("Could not create config path!");
                return;
            }
            Files.writeString(this.getFileLocation(), (CharSequence)config.toJson(Constants.GRAMMAR), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Could not save config!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (!this.configExists()) {
            this.save();
            return;
        }
        try {
            this.loading = true;
            ConfigHandler newValues = (ConfigHandler)this.interpreter.fromJsonCarefully(Files.readString(this.getFileLocation(), StandardCharsets.UTF_8), this.getClass());
            if (newValues == null) {
                LOGGER.error("An unknown error occurred when trying to load the config file!");
                return;
            }
            for (Field field : this.getClass().getDeclaredFields()) {
                Object newValue = field.get(newValues);
                if (this.listeners.containsKey(field.getName()) && !Objects.equals(newValue, field.get(this))) {
                    this.listeners.get(field.getName()).accept(newValue);
                }
                field.set(this, newValue);
            }
        }
        catch (AnnotationParserException e) {
            LOGGER.error("Invalid config! Please follow the constraints", (Throwable)e);
        }
        catch (Throwable e) {
            LOGGER.error("Could not load config!", e);
        }
        finally {
            this.loading = false;
        }
    }

    public boolean canLoad() {
        if (!this.configExists()) {
            return false;
        }
        try {
            this.interpreter.fromJson(Files.readString(this.getFileLocation(), StandardCharsets.UTF_8), this.getClass());
        }
        catch (SyntaxError | IOException e) {
            return false;
        }
        return true;
    }

    public boolean configExists() {
        return Files.exists(this.getFileLocation(), new LinkOption[0]);
    }

    public <T> void registerListener(String key, Consumer<T> listener) {
        this.listeners.put(key, listener);
    }

    public String toString() {
        return this.interpreter.toJson((Object)this).toJson(JsonGrammar.JANKSON);
    }

    public Jankson getInterpreter() {
        return this.interpreter;
    }
}

