/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.discord;

import com.awakenedredstone.autowhitelist.AutoWhitelist;
import com.awakenedredstone.autowhitelist.discord.DiscordBot;
import com.awakenedredstone.autowhitelist.discord.DiscordBotHelper;
import com.awakenedredstone.autowhitelist.entry.BaseEntryAction;
import com.awakenedredstone.autowhitelist.entry.RoleActionMap;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.ISnowflake;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Member;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Role;
import com.awakenedredstone.autowhitelist.util.Stonecutter;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedPlayerProfile;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelist;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelistEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_3330;
import org.jetbrains.annotations.Nullable;

public class PeriodicWhitelistChecker
implements Runnable {
    @Override
    public void run() {
        try {
            this.updateWhitelist();
        }
        catch (Throwable e) {
            AutoWhitelist.LOGGER.error("Failed to run the periodic whitelist check!", e);
        }
    }

    public void updateWhitelist() {
        if (DiscordBot.getGuild() == null) {
            return;
        }
        AutoWhitelist.LOGGER.debug("Reading trough whitelisted players");
        ExtendedWhitelist whitelist = (ExtendedWhitelist)AutoWhitelist.getServer().method_3760().method_14590();
        List<Member> members = DiscordBot.getGuild().findMembers(member -> {
            if (member.getUser().isBot()) {
                return false;
            }
            return DiscordBotHelper.getHighestEntryRole(member).isPresent();
        }).get();
        List<String> memberIds = members.stream().map(ISnowflake::getId).toList();
        List<ExtendedPlayerProfile> playersToRemove = whitelist.getEntries().stream().filter(entry -> entry instanceof ExtendedWhitelistEntry).map(entry -> ((ExtendedWhitelistEntry)((Object)entry)).getProfile()).filter(profile -> !memberIds.contains(profile.getDiscordId())).toList();
        if (!playersToRemove.isEmpty()) {
            AutoWhitelist.LOGGER.debug("Removing {} players that don't qualify", (Object)playersToRemove.size());
            for (ExtendedPlayerProfile profile2 : playersToRemove) {
                AutoWhitelist.LOGGER.debug("Removing entry for {}", (Object)Stonecutter.profileName(profile2));
                AutoWhitelist.removePlayer(profile2);
            }
        }
        for (Member member2 : members) {
            List<ExtendedPlayerProfile> profiles = whitelist.getProfilesFromDiscordId(member2.getId());
            Optional<Role> highestRole = DiscordBotHelper.getHighestEntryRole(DiscordBotHelper.getRolesForMember(member2));
            if (highestRole.isEmpty() || profiles.isEmpty()) continue;
            if (profiles.size() > 1) {
                AutoWhitelist.LOGGER.warn("Duplicate entries of Discord user with id {}. All of them will be removed.", (Object)member2.getId());
                profiles.forEach(whitelist::remove);
                continue;
            }
            ExtendedPlayerProfile profile3 = profiles.get(0);
            if (profile3.getRole().equals(highestRole.get().getId())) continue;
            AutoWhitelist.LOGGER.debug("Updating entry for {}", (Object)Stonecutter.profileName(profile3));
            BaseEntryAction entry2 = RoleActionMap.get(highestRole.get());
            @Nullable BaseEntryAction oldEntry = RoleActionMap.getNullable(profile3.getRole());
            if (oldEntry != null && !oldEntry.isValid()) {
                AutoWhitelist.LOGGER.warn("Failed to validate old entry {}, could not update whitelist for {}", (Object)oldEntry, (Object)member2.getEffectiveName());
                continue;
            }
            if (!entry2.isValid()) {
                AutoWhitelist.LOGGER.warn("Failed to validate new entry {}, could not update whitelist for {}", (Object)entry2, (Object)member2.getEffectiveName());
                continue;
            }
            whitelist.method_14633((class_3330)new ExtendedWhitelistEntry(profile3.withRole(highestRole.get())));
            entry2.updateUser(profile3, oldEntry);
        }
        if (AutoWhitelist.getServer().method_3760().method_14614()) {
            AutoWhitelist.getServer().method_3728(AutoWhitelist.getServer().method_3739());
        }
    }
}

