/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.discord.command;

import com.awakenedredstone.autowhitelist.AutoWhitelist;
import com.awakenedredstone.autowhitelist.LazyConstants;
import com.awakenedredstone.autowhitelist.discord.DiscordBot;
import com.awakenedredstone.autowhitelist.discord.DiscordBotHelper;
import com.awakenedredstone.autowhitelist.discord.api.ReplyCallback;
import com.awakenedredstone.autowhitelist.discord.command.RegisterCommand;
import com.awakenedredstone.autowhitelist.discord.command.SimpleSlashCommand;
import com.awakenedredstone.autowhitelist.lib.jda.api.EmbedBuilder;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Member;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.MessageEmbed;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Role;
import com.awakenedredstone.autowhitelist.lib.jda.api.events.interaction.ModalInteractionEvent;
import com.awakenedredstone.autowhitelist.lib.jda.api.events.interaction.component.ButtonInteractionEvent;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.InteractionHook;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.components.ActionComponent;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.components.ActionRow;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.components.LayoutComponent;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.components.buttons.Button;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.components.selections.StringSelectMenu;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.components.text.TextInput;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.components.text.TextInputStyle;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.modals.Modal;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.modals.ModalMapping;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.WebhookMessageEditAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.messages.MessageEditBuilder;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.messages.MessageEditData;
import com.awakenedredstone.autowhitelist.lib.jdautils.command.SlashCommandEvent;
import com.awakenedredstone.autowhitelist.util.Stonecutter;
import com.awakenedredstone.autowhitelist.util.Texts;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedPlayerProfile;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelist;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelistEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;

public class InfoCommand
extends SimpleSlashCommand {
    public InfoCommand() {
        super("info");
    }

    @Override
    protected void execute(SlashCommandEvent event) {
        ReplyCallback.DefaultInteractionReplyCallback replyCallback = new ReplyCallback.DefaultInteractionReplyCallback(event);
        replyCallback.sendMessage(null);
        Member member = event.getMember();
        if (member == null) {
            AutoWhitelist.LOGGER.error("Member is null", (Throwable)new IllegalStateException());
            MessageEmbed embed = DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.fatal.title"), (class_2561)class_2561.method_43469((String)"discord.command.fatal.generic", (Object[])new Object[]{"Member is null"}), DiscordBotHelper.MessageType.FATAL);
            replyCallback.submitEdit(interactionHook -> interactionHook.editOriginal((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, embed)));
            return;
        }
        String memberId = member.getId();
        MinecraftServer server = AutoWhitelist.getServer();
        ExtendedWhitelist whitelist = (ExtendedWhitelist)server.method_3760().method_14590();
        String eventId = event.getId();
        Optional<ExtendedWhitelistEntry> whitelistedAccount = RegisterCommand.getWhitelistedAccount(memberId, whitelist);
        if (whitelistedAccount.isPresent()) {
            String[] fields;
            ExtendedWhitelistEntry entry = whitelistedAccount.get();
            ExtendedPlayerProfile profile = entry.getProfile();
            EmbedBuilder embed = DiscordBotHelper.Feedback.defaultEmbed((class_2561)class_2561.method_43471((String)"discord.command.info.title"), (class_2561)class_2561.method_43471((String)"discord.command.info.description"));
            for (String field : fields = new String[]{"username", "role", "lock"}) {
                String description;
                String title = Texts.translated("discord.command.info.field.%s.title".formatted(field), new Object[0]);
                if (title.isEmpty()) continue;
                String descriptionKey = "discord.command.info.field.%s.description".formatted(field);
                switch (field) {
                    case "username": {
                        String string = Texts.translated(descriptionKey, Stonecutter.profileName(profile));
                        break;
                    }
                    case "role": {
                        String string = Texts.translated(descriptionKey, "<@&" + profile.getRole() + ">");
                        break;
                    }
                    case "lock": {
                        String time = "future";
                        if (profile.getLockedUntil() == -1L) {
                            time = "permanent";
                        } else if (profile.getLockedUntil() <= System.currentTimeMillis()) {
                            time = "past";
                        }
                        String timeKey = "." + time;
                        String string = Texts.translated(descriptionKey + timeKey, DiscordBotHelper.formatDiscordTimestamp(profile.getLockedUntil()));
                        break;
                    }
                    default: {
                        String string = description = "";
                    }
                }
                if (description.isEmpty()) continue;
                embed.addField(title, description, true);
            }
            Button removeButton = Button.danger(this.btnId(eventId, "delete"), "Remove");
            replyCallback.submitEdit(interactionHook -> (WebhookMessageEditAction)interactionHook.editOriginal((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, embed.build())).setComponents(ActionRow.of(removeButton.withDisabled(profile.isLocked()))));
            if (!profile.isLocked()) {
                ButtonEventHandler buttonEventHandler = new ButtonEventHandler().addConsumer(this.btnId(eventId, "delete"), buttonEvent -> {
                    buttonEvent.editMessage(((MessageEditBuilder)((MessageEditBuilder)new MessageEditBuilder().setContent("Are you sure you want to remove yourself from the whitelist?").setEmbeds(new MessageEmbed[0])).setComponents(ActionRow.of(Button.secondary(this.btnId(eventId, "cancel"), "Cancel"), Button.danger(this.btnId(eventId, "confirmDelete"), "Confirm")))).build()).queue();
                    ButtonEventHandler confirmEventHandler = new ButtonEventHandler().addConsumer(this.btnId(eventId, "confirmDelete"), confirmEvent -> {
                        AutoWhitelist.getWhitelistCache().method_14635((Object)((ExtendedWhitelistEntry)((Object)((Object)((Object)whitelistedAccount.get())))).getProfile());
                        AutoWhitelist.removePlayer(((ExtendedWhitelistEntry)((Object)((Object)((Object)whitelistedAccount.get())))).getProfile());
                        MessageEditBuilder builder = new MessageEditBuilder();
                        builder.setContent("You have been removed from the whitelist.");
                        confirmEvent.editMessage(((MessageEditBuilder)builder.setComponents(new LayoutComponent[0])).build()).queue();
                    }).addConsumer(this.btnId(eventId, "cancel"), confirmEvent -> {
                        MessageEditBuilder builder = new MessageEditBuilder();
                        builder.setContent("Cancelled.");
                        confirmEvent.editMessage(((MessageEditBuilder)builder.setComponents(new LayoutComponent[0])).build()).queue();
                    });
                    this.waitForButton(eventId, replyCallback, confirmEventHandler);
                });
                this.waitForButton(eventId, replyCallback, buttonEventHandler);
            }
        } else {
            MessageEmbed embed = DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.info.missing.title"), (class_2561)class_2561.method_43471((String)"discord.command.info.missing.description"));
            Optional<Role> highestRole = DiscordBotHelper.getHighestEntryRole(member);
            Button button = Button.success(this.btnId(eventId, "register"), "Register").withDisabled(highestRole.isEmpty());
            replyCallback.submitEdit(interactionHook -> (WebhookMessageEditAction)interactionHook.editOriginal((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, embed)).setComponents(ActionRow.of(button)));
            ArrayList<ActionComponent> components = new ArrayList<ActionComponent>();
            components.add(TextInput.create("username", Texts.translated("discord.modal.register.input.label", new Object[0]), TextInputStyle.SHORT).setPlaceholder(Texts.translated("discord.modal.register.input.placeholder", new Object[0])).setRequired(true).build());
            if (LazyConstants.isUsingGeyser()) {
                components.add(((StringSelectMenu.Builder)StringSelectMenu.create("type").addOption(Texts.translated("discord.command.option.register.geyser/java", new Object[0]), "java").addOption(Texts.translated("discord.command.option.register.geyser/bedrock", new Object[0]), "bedrock").setRequiredRange(1, 1)).setDefaultValues("username").build());
            }
            ButtonEventHandler buttonEventHandler = new ButtonEventHandler().addConsumer(this.btnId(eventId, "register"), buttonEvent -> {
                Modal.Builder builder = Modal.create(this.btnId(eventId, "register"), Texts.translated("discord.modal.register.title", new Object[0])).addComponents(ActionRow.of(components));
                buttonEvent.replyModal(builder.build()).queue();
                DiscordBot.eventWaiter.waitForEvent(ModalInteractionEvent.class, modalEvent -> modalEvent.getModalId().equals(this.btnId(eventId, "register")), modalEvent -> {
                    ModalMapping usernameMapping = modalEvent.getValue("username");
                    if (usernameMapping == null) {
                        return;
                    }
                    ModalMapping typeMapping = modalEvent.getValue("type");
                    String username = usernameMapping.getAsString();
                    boolean isBedrock = typeMapping != null && typeMapping.getAsString().equalsIgnoreCase("bedrock");
                    ReplyCallback.InteractionReplyCallback replyCallback1 = new ReplyCallback.InteractionReplyCallback(this, (ModalInteractionEvent)modalEvent){
                        final /* synthetic */ ModalInteractionEvent val$modalEvent;
                        {
                            this.val$modalEvent = modalInteractionEvent;
                        }

                        @Override
                        protected CompletableFuture<InteractionHook> acknowledge() {
                            return this.val$modalEvent.editComponents(new LayoutComponent[0]).submit();
                        }
                    };
                    RegisterCommand.execute(member, username, isBedrock, replyCallback1);
                });
            });
            this.waitForButton(eventId, replyCallback, buttonEventHandler);
        }
    }

    private void waitForButton(String idBase, ReplyCallback.InteractionReplyCallback replyCallback, ButtonEventHandler buttonEventHandler) {
        DiscordBot.eventWaiter.waitForEvent(ButtonInteractionEvent.class, buttonEvent -> buttonEvent.getComponentId().startsWith(idBase), buttonEventHandler::handleEvent, 1L, TimeUnit.MINUTES, () -> replyCallback.submitEdit(rec$ -> ((InteractionHook)rec$).editOriginalComponents(new LayoutComponent[0])));
    }

    private String btnId(String idBase, String suffix) {
        return idBase + "-" + suffix;
    }

    private static class ButtonEventHandler {
        private final Map<String, Consumer<ButtonInteractionEvent>> consumers = new HashMap<String, Consumer<ButtonInteractionEvent>>();

        private ButtonEventHandler() {
        }

        public ButtonEventHandler addConsumer(String id, Consumer<ButtonInteractionEvent> consumer) {
            this.consumers.put(id, consumer);
            return this;
        }

        public void handleEvent(ButtonInteractionEvent event) {
            String id = event.getComponentId();
            if (this.consumers.containsKey(id)) {
                this.consumers.get(id).accept(event);
            }
        }
    }
}

