/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.discord.command;

import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.InteractionContextType;
import com.awakenedredstone.autowhitelist.lib.jdautils.command.SlashCommand;
import com.awakenedredstone.autowhitelist.util.Texts;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleSlashCommand
extends SlashCommand {
    @Nullable
    private final String prefix;

    public SimpleSlashCommand(String command) {
        this(command, null);
    }

    public SimpleSlashCommand(String command, @Nullable String prefix) {
        this.prefix = prefix;
        this.name = command;
        this.help = this.commandDescription();
        this.contexts = new InteractionContextType[]{InteractionContextType.GUILD};
    }

    private String getId() {
        if (StringUtils.isNotBlank((CharSequence)this.prefix)) {
            return this.prefix + "/" + this.name;
        }
        return this.name;
    }

    protected String commandDescription() {
        return Texts.translated("discord.command.description.%s".formatted(this.getId()), new Object[0]);
    }

    protected String argumentText(String argument) {
        return Texts.translated("discord.command.description.%s.argument/%s".formatted(this.getId(), argument), new Object[0]);
    }

    protected String choice(String argument, String option) {
        return Texts.translated("discord.command.option.%s.%s/%s".formatted(this.getId(), argument, option), new Object[0]);
    }
}

