/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.lib.jda.internal.interactions.command;

import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.unions.MessageChannelUnion;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.AutoCompleteQuery;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.Command;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.CommandAutoCompleteInteraction;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.CommandInteractionPayload;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.OptionMapping;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.OptionType;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.interactions.AutoCompleteCallbackAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.data.DataArray;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.data.DataObject;
import com.awakenedredstone.autowhitelist.lib.jda.internal.JDAImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.interactions.InteractionImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.interactions.command.CommandInteractionPayloadImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.interactions.command.CommandInteractionPayloadMixin;
import com.awakenedredstone.autowhitelist.lib.jda.internal.requests.restaction.interactions.AutoCompleteCallbackActionImpl;
import java.util.Collection;
import javax.annotation.Nonnull;

public class CommandAutoCompleteInteractionImpl
extends InteractionImpl
implements CommandInteractionPayloadMixin,
CommandAutoCompleteInteraction {
    private final CommandInteractionPayload payload;
    private AutoCompleteQuery focused;

    public CommandAutoCompleteInteractionImpl(JDAImpl jda, DataObject data) {
        super(jda, data);
        this.payload = new CommandInteractionPayloadImpl(jda, data);
        DataArray options = data.getObject("data").getArray("options");
        this.findFocused(options);
        if (this.focused == null) {
            throw new IllegalStateException("Failed to get focused option for auto complete interaction");
        }
    }

    private void findFocused(DataArray options) {
        block3: for (int i = 0; i < options.length(); ++i) {
            DataObject option = options.getObject(i);
            switch (OptionType.fromKey(option.getInt("type"))) {
                case SUB_COMMAND: 
                case SUB_COMMAND_GROUP: {
                    this.findFocused(option.getArray("options"));
                    continue block3;
                }
                default: {
                    if (!option.getBoolean("focused")) continue block3;
                    OptionMapping opt = this.getOption(option.getString("name"));
                    this.focused = new AutoCompleteQuery(opt);
                    continue block3;
                }
            }
        }
    }

    @Override
    @Nonnull
    public AutoCompleteQuery getFocusedOption() {
        return this.focused;
    }

    @Override
    @Nonnull
    public MessageChannelUnion getChannel() {
        return (MessageChannelUnion)super.getChannel();
    }

    @Override
    public CommandInteractionPayload getCommandPayload() {
        return this.payload;
    }

    @Override
    @Nonnull
    public AutoCompleteCallbackAction replyChoices(@Nonnull Collection<Command.Choice> choices) {
        return new AutoCompleteCallbackActionImpl(this, this.focused.getType()).addChoices(choices);
    }
}

