/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.lib.jdautils.command;

import com.awakenedredstone.autowhitelist.lib.jda.api.Permission;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.GuildVoiceState;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Member;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.middleman.GuildChannel;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.unions.AudioChannelUnion;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.IntegrationType;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.InteractionContextType;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.DefaultMemberPermissions;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.build.CommandData;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.build.Commands;
import com.awakenedredstone.autowhitelist.lib.jdautils.command.ContextMenu;
import com.awakenedredstone.autowhitelist.lib.jdautils.command.UserContextMenuEvent;
import java.util.HashSet;
import java.util.Set;

public abstract class UserContextMenu
extends ContextMenu {
    public final void run(UserContextMenuEvent event) {
        if (this.ownerCommand && !event.isOwner()) {
            this.terminate(event, null);
            return;
        }
        if (this.cooldown > 0 && !event.isOwner()) {
            Permission[] key = this.getCooldownKey(event);
            int remaining = event.getClient().getRemainingCooldown((String)key);
            if (remaining > 0) {
                this.terminate(event, this.getCooldownError(event, remaining, event.getClient()));
                return;
            }
            event.getClient().applyCooldown((String)key, this.cooldown);
        }
        if (event.isFromGuild()) {
            if (this.forceUserPermissions) {
                for (Permission p : this.userPermissions) {
                    if (event.getMember() == null) continue;
                    if (p.isChannel()) {
                        if (event.getMember().hasPermission(event.getGuildChannel(), p)) continue;
                        this.terminate(event, String.format("%s%s%s", event.getClient().getError(), p.getName(), "channel"));
                        return;
                    }
                    if (event.getMember().hasPermission(p)) continue;
                    this.terminate(event, String.format("%s%s%s", event.getClient().getError(), p.getName(), "server"));
                    return;
                }
            }
            for (Permission p : this.botPermissions) {
                Member selfMember;
                if (p == Permission.VIEW_CHANNEL || p == Permission.MESSAGE_EMBED_LINKS) continue;
                Member member = selfMember = event.getGuild() == null ? null : event.getGuild().getSelfMember();
                if (p.isChannel()) {
                    if (p.name().startsWith("VOICE")) {
                        AudioChannelUnion vc;
                        GuildVoiceState gvc = event.getMember().getVoiceState();
                        AudioChannelUnion audioChannelUnion = vc = gvc == null ? null : gvc.getChannel();
                        if (vc == null) {
                            this.terminate(event, event.getClient().getError() + " You must be in a voice channel to use that!");
                            return;
                        }
                        if (selfMember.hasPermission((GuildChannel)vc, p)) continue;
                        this.terminate(event, String.format("%s%s%s", event.getClient().getError(), p.getName(), "voice channel"));
                        return;
                    }
                    if (selfMember.hasPermission(event.getGuildChannel(), p)) continue;
                    this.terminate(event, String.format("%s%s%s", event.getClient().getError(), p.getName(), "channel"));
                    return;
                }
                if (selfMember.hasPermission(p)) continue;
                this.terminate(event, String.format("%s%s%s", event.getClient().getError(), p.getName(), "server"));
                return;
            }
        }
        try {
            this.execute(event);
        }
        catch (Throwable t) {
            if (event.getClient().getListener() != null) {
                event.getClient().getListener().onUserContextMenuException(event, this, t);
                return;
            }
            throw t;
        }
        if (event.getClient().getListener() != null) {
            event.getClient().getListener().onCompletedUserContextMenu(event, this);
        }
    }

    protected abstract void execute(UserContextMenuEvent var1);

    private void terminate(UserContextMenuEvent event, String message) {
        if (message != null) {
            event.reply(message).setEphemeral(true).queue();
        }
        if (event.getClient().getListener() != null) {
            event.getClient().getListener().onTerminatedUserContextMenu(event, this);
        }
    }

    @Override
    public CommandData buildCommandData() {
        CommandData data = Commands.user(this.getName());
        if (this.userPermissions == null) {
            data.setDefaultPermissions(DefaultMemberPermissions.DISABLED);
        } else {
            data.setDefaultPermissions(DefaultMemberPermissions.enabledFor(this.userPermissions));
        }
        Set<InteractionContextType> contexts = this.getContexts();
        if (this.guildOnly != null) {
            if (this.guildOnly.booleanValue()) {
                contexts.remove((Object)InteractionContextType.BOT_DM);
            } else {
                contexts.add(InteractionContextType.BOT_DM);
            }
        }
        data.setNSFW(this.nsfwOnly);
        if (this.guildOnly != null) {
            if (this.guildOnly.booleanValue()) {
                contexts.remove((Object)InteractionContextType.BOT_DM);
            } else {
                contexts.add(InteractionContextType.BOT_DM);
            }
        }
        HashSet<IntegrationType> types = new HashSet<IntegrationType>();
        if (contexts.contains((Object)InteractionContextType.PRIVATE_CHANNEL)) {
            types.add(IntegrationType.USER_INSTALL);
        }
        if (contexts.contains((Object)InteractionContextType.BOT_DM) || contexts.contains((Object)InteractionContextType.GUILD)) {
            types.add(IntegrationType.GUILD_INSTALL);
        }
        data.setIntegrationTypes(types);
        data.setContexts(contexts);
        return data;
    }
}

