/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.concrete;

import com.awakenedredstone.autowhitelist.lib.jda.api.entities.User;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.middleman.MessageChannel;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.detached.IDetachableEntity;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.RestAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.ImageProxy;
import com.awakenedredstone.autowhitelist.lib.jda.internal.utils.Helpers;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface GroupChannel
extends MessageChannel,
IDetachableEntity {
    public static final String ICON_URL = "https://cdn.discordapp.com/channel-icons/%s/%s.png";

    @Nullable
    public String getIconId();

    @Nullable
    default public String getIconUrl() {
        String iconId = this.getIconId();
        return iconId == null ? null : Helpers.format(ICON_URL, this.getId(), iconId);
    }

    @Nullable
    default public ImageProxy getIcon() {
        String iconUrl = this.getIconUrl();
        return iconUrl == null ? null : new ImageProxy(iconUrl);
    }

    public long getOwnerIdLong();

    @Nonnull
    default public String getOwnerId() {
        return Long.toUnsignedString(this.getOwnerIdLong());
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<User> retrieveOwner() {
        return this.getJDA().retrieveUserById(this.getOwnerIdLong());
    }
}

