/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.concrete;

import com.awakenedredstone.autowhitelist.lib.jda.api.Permission;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Guild;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Member;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.StageInstance;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.attribute.IAgeRestrictedChannel;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.attribute.ISlowmodeChannel;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.attribute.IWebhookContainer;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.middleman.AudioChannel;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.middleman.GuildChannel;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.middleman.GuildMessageChannel;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.middleman.StandardGuildChannel;
import com.awakenedredstone.autowhitelist.lib.jda.api.exceptions.InsufficientPermissionException;
import com.awakenedredstone.autowhitelist.lib.jda.api.managers.channel.concrete.StageChannelManager;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.RestAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.ChannelAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.StageInstanceAction;
import com.awakenedredstone.autowhitelist.lib.jda.internal.requests.restaction.StageInstanceActionImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.utils.Checks;
import java.util.EnumSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface StageChannel
extends StandardGuildChannel,
GuildMessageChannel,
AudioChannel,
IWebhookContainer,
IAgeRestrictedChannel,
ISlowmodeChannel {
    public static final int MAX_USERLIMIT = 10000;

    @Nullable
    public StageInstance getStageInstance();

    @Nonnull
    @CheckReturnValue
    default public StageInstanceAction createStageInstance(@Nonnull String topic) {
        Checks.checkAttached(this);
        EnumSet<Permission> permissions = this.getGuild().getSelfMember().getPermissions(this);
        EnumSet<Permission> required = EnumSet.of(Permission.MANAGE_CHANNEL, Permission.VOICE_MUTE_OTHERS, Permission.VOICE_MOVE_OTHERS);
        for (Permission perm : required) {
            if (permissions.contains((Object)perm)) continue;
            throw new InsufficientPermissionException(this, perm, "You must be a stage moderator to create a stage instance! Missing Permission: " + (Object)((Object)perm));
        }
        return new StageInstanceActionImpl(this).setTopic(topic);
    }

    default public boolean isModerator(@Nonnull Member member) {
        Checks.notNull(member, "Member");
        return member.hasPermission((GuildChannel)this, Permission.MANAGE_CHANNEL, Permission.VOICE_MUTE_OTHERS, Permission.VOICE_MOVE_OTHERS);
    }

    @Nonnull
    @CheckReturnValue
    public ChannelAction<StageChannel> createCopy(@Nonnull Guild var1);

    @Nonnull
    @CheckReturnValue
    default public ChannelAction<StageChannel> createCopy() {
        return this.createCopy(this.getGuild());
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public StageChannelManager getManager();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> requestToSpeak();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> cancelRequestToSpeak();
}

