/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.networking;

import com.awakenedredstone.autowhitelist.mixin.authlib.MinecraftClientAccessor;
import com.awakenedredstone.autowhitelist.networking.ErrorResponse;
import com.awakenedredstone.autowhitelist.networking.GeyserAPIClientHttpException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.exceptions.MinecraftClientHttpException;
import com.mojang.authlib.minecraft.client.MinecraftClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeyserAPIClient
extends MinecraftClient {
    public static final Logger LOGGER = LoggerFactory.getLogger(GeyserAPIClient.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public GeyserAPIClient(String accessToken, Proxy proxy) {
        super(accessToken, proxy);
    }

    public static GeyserAPIClient unauthenticated(Proxy proxy) {
        return new GeyserAPIClient(null, proxy);
    }

    @Nullable
    public <T> T get(@NotNull URL url, @NotNull Class<T> responseClass) {
        Objects.requireNonNull(url);
        Objects.requireNonNull(responseClass);
        HttpURLConnection connection = this.createUrlConnection(url);
        if (this.getAccessToken() != null) {
            connection.setRequestProperty("Authorization", "Bearer " + this.getAccessToken());
        }
        return this.readInputStream(url, responseClass, connection);
    }

    @Nullable
    private <T> T readInputStream(URL url, Class<T> clazz, HttpURLConnection connection) {
        int status;
        InputStream inputStream;
        block8: {
            String result;
            block9: {
                inputStream = null;
                status = connection.getResponseCode();
                if (status >= 400) break block8;
                inputStream = connection.getInputStream();
                result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (!result.isEmpty()) break block9;
                T t = null;
                IOUtils.closeQuietly((InputStream)inputStream);
                return t;
            }
            Object object = this.objectMapper.readValue(result, clazz);
            IOUtils.closeQuietly((InputStream)inputStream);
            return (T)object;
        }
        try {
            try {
                String contentType = connection.getContentType();
                inputStream = connection.getErrorStream();
                if (inputStream != null) {
                    String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    if (contentType != null && contentType.startsWith("text/html")) {
                        LOGGER.error("Got an error with a html body connecting to {}: {}", (Object)url.toString(), (Object)result);
                        throw new MinecraftClientHttpException(status);
                    }
                    ErrorResponse errorResponse = (ErrorResponse)this.objectMapper.readValue(result, ErrorResponse.class);
                    throw new GeyserAPIClientHttpException(status, errorResponse);
                }
                throw new MinecraftClientHttpException(status);
            }
            catch (IOException e) {
                throw new MinecraftClientException(MinecraftClientException.ErrorType.SERVICE_UNAVAILABLE, "Failed to read from " + String.valueOf(url) + " due to " + e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
    }

    protected HttpURLConnection createUrlConnection(URL url) {
        return ((MinecraftClientAccessor)((Object)this)).callCreateUrlConnection(url);
    }

    private String getAccessToken() {
        return ((MinecraftClientAccessor)((Object)this)).autowhitelist$getAccessToken();
    }

    private Proxy getProxy() {
        return ((MinecraftClientAccessor)((Object)this)).autowhitelist$getProxy();
    }
}

