/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.networking;

import com.awakenedredstone.autowhitelist.networking.ErrorResponse;
import com.mojang.authlib.exceptions.MinecraftClientException;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class GeyserAPIClientHttpException
extends MinecraftClientException {
    private final int status;
    @Nullable
    private final ErrorResponse response;

    public GeyserAPIClientHttpException(int status) {
        super(MinecraftClientException.ErrorType.HTTP_ERROR, GeyserAPIClientHttpException.getErrorMessage(status, null));
        this.status = status;
        this.response = null;
    }

    public GeyserAPIClientHttpException(int status, @Nullable ErrorResponse response) {
        super(MinecraftClientException.ErrorType.HTTP_ERROR, GeyserAPIClientHttpException.getErrorMessage(status, response));
        this.status = status;
        this.response = response;
    }

    public int getStatus() {
        return this.status;
    }

    public Optional<ErrorResponse> getResponse() {
        return Optional.ofNullable(this.response);
    }

    public String toString() {
        return new StringJoiner(", ", GeyserAPIClientHttpException.class.getSimpleName() + "[", "]").add("type=" + String.valueOf(this.type)).add("status=" + this.status).add("response=" + String.valueOf(this.response)).toString();
    }

    public Optional<String> getError() {
        return this.getResponse().map(ErrorResponse::message).filter(StringUtils::isNotEmpty);
    }

    private static String getErrorMessage(int status, ErrorResponse response) {
        Object errorMessage = response != null ? (StringUtils.isNotEmpty((CharSequence)response.message()) ? response.message() : "Status: " + status) : "Status: " + status;
        return errorMessage;
    }

    public boolean hasError(String error) {
        return this.getError().filter(value -> value.equalsIgnoreCase(error)).isPresent();
    }
}

