/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.util;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonPrimitive;
import blue.endless.jankson.api.DeserializerFunction;
import com.awakenedredstone.autowhitelist.config.source.annotation.PredicateConstraint;
import com.awakenedredstone.autowhitelist.config.source.annotation.RangeConstraint;
import com.awakenedredstone.autowhitelist.config.source.annotation.RegexConstraint;
import com.awakenedredstone.autowhitelist.config.source.jankson.Marshaller;
import com.awakenedredstone.autowhitelist.mixin.jankson.JanksonAccessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanksonBuilder {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Jankson Marshaller");
    public static final Jankson DEFAULT = JanksonBuilder.buildJankson();

    public static Jankson buildJankson() {
        return JanksonBuilder.buildJankson(builder -> {});
    }

    public static Jankson buildJankson(Consumer<Builder> janksonBuilder) {
        Builder builder = new Builder().registerSerializer(class_2960.class, (identifier, marshaller) -> new JsonPrimitive((Object)identifier.toString())).registerDeserializer(JsonPrimitive.class, class_2960.class, (primitive, m) -> class_2960.method_12829((String)primitive.asString())).registerSerializer(UUID.class, (uuid, marshaller) -> {
            JsonArray array = new JsonArray();
            array.add((JsonElement)new JsonPrimitive((Object)uuid.getMostSignificantBits()));
            array.add((JsonElement)new JsonPrimitive((Object)uuid.getLeastSignificantBits()));
            return array;
        }).registerDeserializer(JsonArray.class, UUID.class, (json, m) -> new UUID(json.getLong(0, 0L), json.getLong(1, 0L))).registerSerializer(class_2338.class, (blockPos, marshaller) -> {
            JsonArray array = new JsonArray();
            array.add((JsonElement)new JsonPrimitive((Object)blockPos.method_10263()));
            array.add((JsonElement)new JsonPrimitive((Object)blockPos.method_10264()));
            array.add((JsonElement)new JsonPrimitive((Object)blockPos.method_10260()));
            return array;
        }).registerDeserializer(JsonArray.class, class_2338.class, (json, m) -> new class_2338(json.getInt(0, 0), json.getInt(1, 0), json.getInt(2, 0))).registerSerializer(class_243.class, (vec3d, marshaller) -> {
            JsonArray array = new JsonArray();
            array.add((JsonElement)new JsonPrimitive((Object)vec3d.method_10216()));
            array.add((JsonElement)new JsonPrimitive((Object)vec3d.method_10214()));
            array.add((JsonElement)new JsonPrimitive((Object)vec3d.method_10215()));
            return array;
        }).registerDeserializer(JsonArray.class, class_243.class, (json, m) -> new class_243(json.getDouble(0, 0.0), json.getDouble(1, 0.0), json.getDouble(2, 0.0))).registerAnnotationProcessor(PredicateConstraint.class, (annotation, object, clazz, fieldName) -> {
            Method method2;
            List<Method> methods = Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals(annotation.value())).toList();
            if (methods.size() > 1) {
                LOGGER.warn("Multiple methods found with the same name, trying to find the most suitable one");
                method2 = methods.stream().filter(m -> m.getParameterCount() == 1 && m.getParameterTypes()[0].isAssignableFrom(object.getClass())).findFirst().orElse(null);
                if (method2 == null) {
                    throw new IllegalStateException("No suitable " + annotation.value() + " method found for " + fieldName);
                }
            } else if (methods.size() == 1) {
                method2 = methods.get(0);
            } else {
                throw new IllegalStateException("No " + annotation.value() + " method found for " + fieldName);
            }
            if (method2.getReturnType() != Boolean.TYPE) {
                throw new IllegalStateException("The method " + method2.getName() + " must return a " + Boolean.TYPE.getSimpleName());
            }
            if (method2.getParameterCount() != 1) {
                throw new IllegalStateException("The method " + method2.getName() + " must have only one parameter");
            }
            if (!method2.getParameterTypes()[0].isAssignableFrom(object.getClass())) {
                throw new IllegalStateException("The method " + method2.getName() + " must have a parameter of type " + object.getClass().getSimpleName());
            }
            try {
                return (Boolean)method2.invoke(null, object);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Failed to invoke " + method2.getName() + " for " + fieldName, e);
            }
        }).registerAnnotationProcessor(RegexConstraint.class, (annotation, object, clazz, fieldName) -> object.toString().matches(annotation.value())).registerAnnotationProcessor(RangeConstraint.class, (annotation, object, clazz, fieldName) -> {
            if (object instanceof Number) {
                boolean minValid;
                Number number = (Number)object;
                boolean bl = annotation.minInclusive() ? number.doubleValue() >= annotation.min() : (minValid = number.doubleValue() > annotation.min());
                boolean maxValid = annotation.maxInclusive() ? number.doubleValue() <= annotation.max() : number.doubleValue() < annotation.max();
                boolean minusOneValid = !annotation.minusOne() || number.doubleValue() != -1.0;
                return minValid && maxValid && minusOneValid;
            }
            throw new IllegalStateException("The field " + fieldName + " must be a number to use the " + annotation.annotationType().getSimpleName());
        });
        janksonBuilder.accept(builder);
        return builder.build();
    }

    public static class Builder
    extends Jankson.Builder {
        protected final Marshaller marshaller = new Marshaller();
        boolean allowBareRootObject = false;

        public <T> Builder registerSerializer(Class<T> clazz, BiFunction<T, blue.endless.jankson.api.Marshaller, JsonElement> serializer) {
            this.marshaller.registerSerializer(clazz, serializer);
            return this;
        }

        public <A, B> Builder registerDeserializer(Class<A> sourceClass, Class<B> targetClass, DeserializerFunction<A, B> function) {
            this.marshaller.registerDeserializer(sourceClass, targetClass, function);
            return this;
        }

        public <A extends Annotation, O> Builder registerAnnotationProcessor(Class<A> annotation, Marshaller.AnnotationProcessor<A, O> processor) {
            this.marshaller.registerAnnotationProcessor(annotation, processor);
            return this;
        }

        public <T> Builder registerTypeFactory(Class<T> clazz, Supplier<T> factory) {
            this.marshaller.registerTypeFactory(clazz, factory);
            return this;
        }

        public Builder allowBareRootObject() {
            this.allowBareRootObject = true;
            return this;
        }

        public Jankson build() {
            Jankson result = JanksonAccessor.createJankson(this);
            JanksonAccessor accessor = (JanksonAccessor)result;
            accessor.setMarshaller(this.marshaller);
            accessor.setAllowBareRootObject(this.allowBareRootObject);
            return result;
        }
    }
}

