/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.whitelist;

import com.awakenedredstone.autowhitelist.AutoWhitelist;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Role;
import com.awakenedredstone.autowhitelist.util.Stonecutter;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;

public class ExtendedPlayerProfile
extends GameProfile {
    private final String role;
    private final String discordId;
    private final long lockedUntil;

    public ExtendedPlayerProfile(GameProfile profile) {
        super(Stonecutter.profileId(profile), Stonecutter.profileName(profile));
        this.role = null;
        this.discordId = null;
        this.lockedUntil = -1L;
    }

    public ExtendedPlayerProfile(UUID id, String name, String role, String discordId, long lockedUntil) {
        super(id, name);
        this.role = role;
        this.discordId = discordId;
        this.lockedUntil = lockedUntil;
    }

    public String getRole() {
        return this.role;
    }

    public String getDiscordId() {
        return this.discordId;
    }

    public long getLockedUntil() {
        if (AutoWhitelist.CONFIG.lockTime() == -1L) {
            return -1L;
        }
        return AutoWhitelist.getServer().method_3760().method_14563().method_14650((GameProfile)this) ? -1L : this.lockedUntil;
    }

    public ExtendedPlayerProfile withRole(String newRole) {
        return new ExtendedPlayerProfile(Stonecutter.profileId(this), Stonecutter.profileName(this), newRole, this.discordId, this.lockedUntil);
    }

    public ExtendedPlayerProfile withRole(Role newRole) {
        return this.withRole(newRole.getId());
    }

    public ExtendedPlayerProfile withLockedUntil(long newLockedUntil) {
        return new ExtendedPlayerProfile(Stonecutter.profileId(this), Stonecutter.profileName(this), this.role, this.discordId, newLockedUntil);
    }

    public boolean isLocked() {
        return AutoWhitelist.CONFIG.lockTime() == -1L || this.lockedUntil == -1L || this.lockedUntil > System.currentTimeMillis() || AutoWhitelist.getServer().method_3760().method_14563().method_14650((GameProfile)this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)Stonecutter.profileId(this)).append("name", (Object)Stonecutter.profileName(this)).append("properties", (Object)this.getProperties()).append("role", (Object)this.role).append("discordId", (Object)this.discordId).append("lockedUntil", this.lockedUntil).toString();
    }

    @Nullable
    public static ExtendedPlayerProfile read(JsonObject object) {
        if (ExtendedPlayerProfile.jsonHasAllKeys(object, "uuid", "name", "discordId", "role", "lockedUntil")) {
            UUID uuid;
            String uuidString = object.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(uuidString);
            }
            catch (Throwable e) {
                return null;
            }
            return new ExtendedPlayerProfile(uuid, object.get("name").getAsString(), object.get("role").getAsString(), object.get("discordId").getAsString(), object.get("lockedUntil").getAsLong());
        }
        return null;
    }

    public void write(JsonObject object) {
        object.addProperty("uuid", Stonecutter.profileId(this).toString());
        object.addProperty("name", Stonecutter.profileName(this));
        object.addProperty("role", this.getRole());
        object.addProperty("discordId", this.getDiscordId());
        object.addProperty("lockedUntil", (Number)this.getLockedUntil());
    }

    private static boolean jsonHasAllKeys(JsonObject json, String ... keys) {
        for (String key : keys) {
            if (json.has(key)) continue;
            return false;
        }
        return true;
    }
}

