/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.config;

import blue.endless.jankson.Comment;
import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import com.awakenedredstone.autowhitelist.AutoWhitelist;
import com.awakenedredstone.autowhitelist.Constants;
import com.awakenedredstone.autowhitelist.config.source.ConfigHandler;
import com.awakenedredstone.autowhitelist.config.source.annotation.NameFormat;
import com.awakenedredstone.autowhitelist.config.source.annotation.PredicateConstraint;
import com.awakenedredstone.autowhitelist.config.source.annotation.RangeConstraint;
import com.awakenedredstone.autowhitelist.config.source.annotation.SkipNameFormat;
import com.awakenedredstone.autowhitelist.entry.BaseEntryAction;
import com.awakenedredstone.autowhitelist.entry.implementation.CommandEntryAction;
import com.awakenedredstone.autowhitelist.entry.implementation.VanillaTeamEntryAction;
import com.awakenedredstone.autowhitelist.entry.implementation.WhitelistEntryAction;
import com.awakenedredstone.autowhitelist.entry.implementation.luckperms.GroupEntryAction;
import com.awakenedredstone.autowhitelist.entry.implementation.luckperms.PermissionEntryAction;
import com.awakenedredstone.autowhitelist.entry.serialization.JanksonOps;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Activity;
import com.awakenedredstone.autowhitelist.util.JanksonBuilder;
import com.awakenedredstone.autowhitelist.util.JsonUtil;
import com.awakenedredstone.autowhitelist.util.Stonecutter;
import com.awakenedredstone.autowhitelist.util.TimeParser;
import com.google.common.base.CaseFormat;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@NameFormat(value=NameFormat.Case.SNAKE_CASE)
public class AutoWhitelistConfig
extends ConfigHandler {
    @SkipNameFormat
    @Comment(value="The JSON schema for the config, this is for text editors to show syntax highlighting, do not change it")
    public String $schema = Constants.CONFIG_SCHEMA;
    @SkipNameFormat
    @Comment(value="DO NOT CHANGE, MODIFYING THIS VALUE WILL BREAK THE CONFIGURATION FILE")
    public byte CONFIG_VERSION = (byte)6;
    @Comment(value="When enabled, it will keep a cache of previous registered users and will use it to automatically add the user back (if they have the proper role)")
    public boolean enableWhitelistCache = true;
    @RangeConstraint(min=10.0, max=600.0)
    @Comment(value="The delay (in seconds) for checking for invalid and outdated entries. This ensures everything is up to date in case the bot misses an event\n[Min: 10, Max: 600]")
    public short periodicCheckDelay = (short)60;
    @Comment(value="The activity type shown on the bot status, must be in UPPERCASE")
    public BotActivity botActivityType = BotActivity.PLAYING;
    @Comment(value="The text shown on the bot activity status")
    public String botActivityText = "on the Member Server";
    @PredicateConstraint(value="timeConstraint")
    @Comment(value="The time the bot will lock a whitelist entry after it is added or updated, use -1 to lock all entries forever\nChanges to this value will only apply to new entries, except for permanent lock which is immediate and global\nCheck the documentation for more details on how the format works")
    public String lockTime = "1d";
    @Comment(value="Your bot's token. Never share it, anyone with it has full control of the bot")
    public String token = "DO NOT SHARE THE BOT TOKEN";
    @RangeConstraint(min=0.0, max=9.223372036854776E18)
    public long discordServerId = 0L;
    @Comment(value="When enabled, all interactions and slash commands will be ephemeral, meaning only the user can see the response.")
    public boolean ephemeralReplies = true;
    @Comment(value="When enabled, the bot will cache the data of the users on discord, this reduces response time, but may cause higher memory usage on large discord servers.")
    public boolean cacheDiscordData = true;
    @RangeConstraint(min=0.0, max=4.0)
    @Comment(value="The permission level used for command entries. This limits what commands the mod can run, you likely don't need to change this.\nCheck https://minecraft.wiki/w/Permission_level for more about permission levels.")
    public int commandPermissionLevel = 3;
    @Comment(value="The whitelist entry settings, please refer to the documentation to set them up")
    public List<BaseEntryAction> entries = new ArrayList<BaseEntryAction>();

    public AutoWhitelistConfig() {
        super("autowhitelist", JanksonBuilder.buildJankson(builder -> {
            builder.registerDeserializer(JsonObject.class, BaseEntryAction.class, (jsonObject, marshaller) -> (BaseEntryAction)Stonecutter.getOrThrowDataResult(BaseEntryAction.CODEC.parse((DynamicOps)JanksonOps.INSTANCE, jsonObject)));
            builder.registerSerializer(BaseEntryAction.class, (entryData, marshaller) -> (JsonElement)Stonecutter.getOrThrowDataResult(BaseEntryAction.CODEC.encodeStart((DynamicOps)JanksonOps.INSTANCE, entryData)));
        }));
    }

    public static boolean timeConstraint(String timeString) {
        if (timeString.equals("-1")) {
            return true;
        }
        int time = TimeParser.parseTime(timeString);
        return time >= 0;
    }

    public long lockTime() {
        if (this.lockTime.trim().equals("-1")) {
            return -1L;
        }
        int time = TimeParser.parseTime(this.lockTime);
        return System.currentTimeMillis() + (long)time * 1000L;
    }

    @Override
    public String toString() {
        return super.toString().replace(this.token, "[HIDDEN]").replace(String.valueOf(this.discordServerId), "[HIDDEN]");
    }

    @Override
    public void load() {
        if (!this.configExists()) {
            super.load();
            return;
        }
        try {
            Object config = this.getInterpreter().load(Files.readString(this.getFileLocation(), StandardCharsets.UTF_8));
            byte configVersion = config.getByte("CONFIG_VERSION", (byte)6);
            if (configVersion != 6) {
                AutoWhitelist.DATA_FIXER_LOGGER.info("New config version available!");
                AutoWhitelist.DATA_FIXER_LOGGER.info("Updating config from {} to {}", (Object)configVersion, (Object)6);
            }
            switch (configVersion) {
                case 1: {
                    AutoWhitelist.DATA_FIXER_LOGGER.info("Updating config file from v{} to v{}", (Object)configVersion, (Object)6);
                    JsonArray entries = (JsonArray)config.get(JsonArray.class, "entries");
                    if (entries != null) {
                        ArrayList<BaseEntryAction> entryList = new ArrayList<BaseEntryAction>();
                        for (JsonElement jsonElement : entries) {
                            class_2960 class_29602;
                            JsonObject entryData = (JsonObject)jsonElement;
                            String oldType = (String)entryData.get(String.class, "type");
                            if (oldType != null) {
                                switch (oldType) {
                                    case "WHITELIST": {
                                        class_29602 = WhitelistEntryAction.ID;
                                        break;
                                    }
                                    case "COMMAND": {
                                        class_29602 = CommandEntryAction.ID;
                                        break;
                                    }
                                    case "TEAM": {
                                        class_29602 = VanillaTeamEntryAction.ID;
                                        break;
                                    }
                                    case "LUCKPERMS_GROUP": {
                                        class_29602 = GroupEntryAction.ID;
                                        break;
                                    }
                                    case "LUCKPERMS_PERMISSION": {
                                        class_29602 = PermissionEntryAction.ID;
                                        break;
                                    }
                                    default: {
                                        class_29602 = null;
                                    }
                                }
                            } else {
                                AutoWhitelist.DATA_FIXER_LOGGER.warn("Could not get type of an entry, the invalid entry was removed!");
                                continue;
                            }
                            class_2960 newType = class_29602;
                            if (newType == null) {
                                AutoWhitelist.DATA_FIXER_LOGGER.warn("Unknown entry type [{}], can not update to new config, the invalid entry was removed!", (Object)oldType);
                                continue;
                            }
                            AutoWhitelist.DATA_FIXER_LOGGER.debug("Updating entry name from {} to {}", (Object)oldType, (Object)newType);
                            entryData.remove((Object)"type");
                            entryData.put("type", (JsonElement)Stonecutter.getOrThrowDataResult(class_2960.field_25139.encodeStart((DynamicOps)JanksonOps.INSTANCE, (Object)newType)));
                            JsonArray rolesArray = (JsonArray)entryData.get(JsonArray.class, "roleIds");
                            if (rolesArray == null) {
                                rolesArray = new JsonArray();
                            }
                            entryData.put("roles", (JsonElement)rolesArray);
                            entryData.remove((Object)"roleIds");
                            entryData = BaseEntryAction.getDataFixers().get(newType).apply(configVersion, entryData);
                            entryList.add((BaseEntryAction)Stonecutter.getOrThrowDataResult(BaseEntryAction.CODEC.parse((DynamicOps)JanksonOps.INSTANCE, (Object)entryData)));
                        }
                        entries.clear();
                        for (BaseEntryAction entry : entryList) {
                            AutoWhitelist.LOGGER.debug("Encoding {}", (Object)entry.getType());
                            entries.add((JsonElement)Stonecutter.getOrThrowDataResult(BaseEntryAction.CODEC.encodeStart((DynamicOps)JanksonOps.INSTANCE, (Object)entry)));
                        }
                        config.remove((Object)"entries");
                        config.put("entries", (JsonElement)entries);
                    }
                    String newConfig = new JsonObject();
                    config.forEach((arg_0, arg_1) -> this.lambda$load$3((JsonObject)newConfig, arg_0, arg_1));
                    config = newConfig;
                    configVersion = config.getByte("CONFIG_VERSION", (byte)6);
                }
                case 2: {
                    String activityType = (String)config.get(String.class, "bot_activity_type");
                    if (activityType == null) break;
                    activityType = switch (activityType.toUpperCase()) {
                        case "NONE" -> "DONT_CHANGE";
                        case "RESET" -> "CLEAR";
                        default -> activityType;
                    };
                    config.put("bot_activity_type", (JsonElement)new JsonPrimitive((Object)activityType));
                }
            }
            if (configVersion < 3 && !config.containsKey((Object)"cache_discord_data")) {
                config.put("cache_discord_data", (JsonElement)new JsonPrimitive((Object)this.cacheDiscordData), this.getComment("cacheDiscordData"));
            }
            if (configVersion < 5) {
                config.put("command_permission_level", (JsonElement)new JsonPrimitive((Object)this.commandPermissionLevel), this.getComment("commandPermissionLevel"));
            }
            if (configVersion < 6) {
                config.remove((Object)"admins");
                config.remove((Object)"prefix");
                JsonUtil.rename(config, "update_period", "periodic_check_delay", this.getComment("periodicCheckDelay"));
            }
            if (configVersion != 6) {
                JsonObject newJson = new JsonObject();
                String comment = this.getComment("$schema");
                newJson.put("$schema", (JsonElement)new JsonPrimitive((Object)Constants.CONFIG_SCHEMA), comment);
                Object finalConfig = config;
                config.forEach((arg_0, arg_1) -> AutoWhitelistConfig.lambda$load$4(newJson, (JsonObject)finalConfig, arg_0, arg_1));
                newJson.put("CONFIG_VERSION", (JsonElement)new JsonPrimitive((Object)6));
                AutoWhitelist.DATA_FIXER_LOGGER.info("Saving updated config");
                this.save((JsonElement)newJson);
            }
        }
        catch (Exception e) {
            AutoWhitelist.DATA_FIXER_LOGGER.error("The config updater crashed!", (Throwable)e);
        }
        super.load();
    }

    @Nullable
    private String getComment(String key) {
        String comment;
        try {
            Field field = this.getClass().getField(key);
            comment = field.isAnnotationPresent(Comment.class) ? field.getAnnotation(Comment.class).value() : null;
        }
        catch (NoSuchFieldException e) {
            comment = null;
        }
        return comment;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    private static /* synthetic */ void lambda$load$4(JsonObject newJson, JsonObject finalConfig, String key, JsonElement jsonElement) {
        if (key.equals("$schema")) {
            return;
        }
        newJson.put(key, jsonElement, finalConfig.getComment(key));
    }

    private /* synthetic */ void lambda$load$3(JsonObject newConfig, String key, JsonElement jsonElement) {
        String comment = this.getComment(key);
        if (key.equals("CONFIG_VERSION")) {
            newConfig.put(key, jsonElement, comment);
            return;
        }
        if (key.equals("admins")) {
            JsonArray newAdmins = new JsonArray();
            for (JsonElement element : (JsonArray)jsonElement) {
                try {
                    newAdmins.add((JsonElement)new JsonPrimitive((Object)Long.parseLong(((JsonPrimitive)element).asString())));
                }
                catch (Throwable e) {
                    AutoWhitelist.DATA_FIXER_LOGGER.warn("Invalid user Id: {}, the value was removed", (Object)jsonElement);
                }
            }
            jsonElement = newAdmins;
        }
        if (key.equals("discordServerId")) {
            try {
                jsonElement = new JsonPrimitive((Object)Long.parseLong(((JsonPrimitive)jsonElement).asString()));
            }
            catch (Throwable e) {
                AutoWhitelist.DATA_FIXER_LOGGER.warn("Invalid user Id: {}, replacing with default", (Object)jsonElement);
                jsonElement = new JsonPrimitive((Object)0L);
            }
        }
        String newKey = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, key);
        AutoWhitelist.DATA_FIXER_LOGGER.debug("Updating {} to {}", (Object)key, (Object)newKey);
        newConfig.put(newKey, jsonElement, comment);
    }

    public static enum BotActivity {
        DONT_CHANGE(null),
        CLEAR(null),
        PLAYING(Activity.ActivityType.PLAYING),
        STREAMING(Activity.ActivityType.STREAMING),
        LISTENING(Activity.ActivityType.LISTENING),
        WATCHING(Activity.ActivityType.WATCHING);

        private final Activity.ActivityType activityType;

        private BotActivity(Activity.ActivityType activityType) {
            this.activityType = activityType;
        }

        public Activity.ActivityType getActivityType() {
            return this.activityType;
        }

        public Activity getActivity() {
            return this.activityType == null ? null : Activity.of(this.getActivityType(), AutoWhitelist.CONFIG.botActivityText);
        }
    }
}

