/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.lib.jda.api.interactions.callbacks;

import com.awakenedredstone.autowhitelist.lib.jda.api.entities.MessageEmbed;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.callbacks.IDeferrableCallback;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.components.ActionRow;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.components.LayoutComponent;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.interactions.MessageEditCallbackAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.AttachedFile;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.messages.MessageEditData;
import com.awakenedredstone.autowhitelist.lib.jda.internal.requests.restaction.interactions.MessageEditCallbackActionImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.utils.Checks;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface IMessageEditCallback
extends IDeferrableCallback {
    @Nonnull
    @CheckReturnValue
    public MessageEditCallbackAction deferEdit();

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessage(@Nonnull MessageEditData message) {
        Checks.notNull(message, "Message");
        MessageEditCallbackActionImpl action = (MessageEditCallbackActionImpl)this.deferEdit();
        return (MessageEditCallbackAction)action.applyData(message);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessage(@Nonnull String content) {
        Checks.notNull(content, "Content");
        return (MessageEditCallbackAction)this.deferEdit().setContent(content);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editComponents(@Nonnull Collection<? extends LayoutComponent> components) {
        Checks.noneNull(components, "Components");
        if (components.stream().anyMatch(it -> !(it instanceof ActionRow))) {
            throw new UnsupportedOperationException("The provided component layout is not supported");
        }
        List actionRows = components.stream().map(ActionRow.class::cast).collect(Collectors.toList());
        return (MessageEditCallbackAction)this.deferEdit().setComponents(actionRows);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editComponents(LayoutComponent ... components) {
        Checks.noneNull(components, "LayoutComponents");
        return this.editComponents(Arrays.asList(components));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessageEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        Checks.noneNull(embeds, "MessageEmbed");
        return (MessageEditCallbackAction)this.deferEdit().setEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessageEmbeds(MessageEmbed ... embeds) {
        Checks.noneNull(embeds, "MessageEmbed");
        return (MessageEditCallbackAction)this.deferEdit().setEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessageFormat(@Nonnull String format, Object ... args) {
        Checks.notNull(format, "Format String");
        return this.editMessage(String.format(format, args));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessageAttachments(@Nonnull Collection<? extends AttachedFile> attachments) {
        Checks.noneNull(attachments, "Attachments");
        return (MessageEditCallbackAction)this.deferEdit().setAttachments(attachments);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction editMessageAttachments(AttachedFile ... attachments) {
        Checks.noneNull(attachments, "Attachments");
        return (MessageEditCallbackAction)this.deferEdit().setAttachments(attachments);
    }
}

