/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.networking;

import com.awakenedredstone.autowhitelist.networking.GeyserAPIClient;
import com.awakenedredstone.autowhitelist.networking.GeyserAPIClientHttpException;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.authlib.yggdrasil.response.NameAndId;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeyserProfileRepository
implements GameProfileRepository {
    public static final Logger LOGGER = LoggerFactory.getLogger(GeyserProfileRepository.class);
    private static final int MAX_FAIL_COUNT = 3;
    private static final int DELAY_BETWEEN_USERS = 100;
    private static final int DELAY_BETWEEN_FAILURES = 750;
    private final GeyserAPIClient client = GeyserAPIClient.unauthenticated(Proxy.NO_PROXY);
    private final HttpUrl searchPageUrl = new HttpUrl.Builder().scheme("https").host("api.geysermc.org").addPathSegments("/v2/xbox/xuid/").build();

    public void findProfilesByNames(String[] names, ProfileLookupCallback callback) {
        Set criteria = Arrays.stream(names).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        for (String request : criteria) {
            boolean failed;
            String normalizedRequest = GeyserProfileRepository.normalizeName(request);
            int failCount = 0;
            do {
                failed = false;
                try {
                    ProfileSearchResultsResponse response = this.client.get(this.searchPageUrl.newBuilder().addPathSegment(normalizedRequest).build().url(), ProfileSearchResultsResponse.class);
                    failCount = 0;
                    if (response == null) {
                        LOGGER.debug("Couldn't find profile {}", (Object)normalizedRequest);
                        callback.onProfileLookupFailed(GeyserProfileRepository.error(normalizedRequest), (Exception)new ProfileNotFoundException("Server did not find the requested profile"));
                        this.sleep(100L);
                        continue;
                    }
                    LOGGER.debug("Successfully looked up profile {}", (Object)normalizedRequest);
                    callback.onProfileLookupSucceeded(normalizedRequest, new UUID(0L, response.xuid()));
                    this.sleep(100L);
                }
                catch (MinecraftClientException e) {
                    GeyserAPIClientHttpException httpException;
                    if (e instanceof GeyserAPIClientHttpException && (httpException = (GeyserAPIClientHttpException)e).hasError("Unable to find user in our cache. Please try specifying their Floodgate UUID instead")) {
                        LOGGER.debug("Couldn't find profile {} [User not in cache]", (Object)normalizedRequest);
                        callback.onProfileLookupFailed(GeyserProfileRepository.error(normalizedRequest), (Exception)new ProfileNotFoundException("Server did not find the requested profile in the cache"));
                        this.sleep(100L);
                        continue;
                    }
                    if (++failCount == 3) {
                        LOGGER.debug("Couldn't find profile {} because of a server error", (Object)normalizedRequest);
                        callback.onProfileLookupFailed(GeyserProfileRepository.error(normalizedRequest), (Exception)e.toAuthenticationException());
                        continue;
                    }
                    this.sleep(750L);
                    failed = true;
                }
            } while (failed);
        }
    }

    public Optional<NameAndId> findProfileByName(String name) {
        String normalizedRequest = GeyserProfileRepository.normalizeName(name);
        try {
            ProfileSearchResultsResponse response = this.client.get(this.searchPageUrl.newBuilder().addPathSegment(normalizedRequest).build().url(), ProfileSearchResultsResponse.class);
            if (response != null) {
                return Optional.of(new NameAndId(new UUID(0L, response.xuid()), normalizedRequest));
            }
        }
        catch (MinecraftClientException e) {
            LOGGER.warn("Couldn't find profile with name: {}", (Object)name, (Object)e);
        }
        return Optional.empty();
    }

    private static String normalizeName(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    private static String error(String request) {
        return request;
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public record ProfileSearchResultsResponse(long xuid) {
    }
}

