/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist;

import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import com.awakenedredstone.autowhitelist.commands.AutoWhitelistCommand;
import com.awakenedredstone.autowhitelist.config.AutoWhitelistConfig;
import com.awakenedredstone.autowhitelist.discord.DiscordBot;
import com.awakenedredstone.autowhitelist.discord.DiscordBotHelper;
import com.awakenedredstone.autowhitelist.duck.WhitelistCacheHolder;
import com.awakenedredstone.autowhitelist.entry.BaseEntryAction;
import com.awakenedredstone.autowhitelist.entry.RoleActionMap;
import com.awakenedredstone.autowhitelist.entry.implementation.CommandEntryAction;
import com.awakenedredstone.autowhitelist.entry.implementation.VanillaTeamEntryAction;
import com.awakenedredstone.autowhitelist.entry.implementation.WhitelistEntryAction;
import com.awakenedredstone.autowhitelist.entry.implementation.luckperms.GroupEntryAction;
import com.awakenedredstone.autowhitelist.entry.implementation.luckperms.PermissionEntryAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Member;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Role;
import com.awakenedredstone.autowhitelist.mixin.ServerLoginNetworkHandlerAccessor;
import com.awakenedredstone.autowhitelist.util.JsonUtil;
import com.awakenedredstone.autowhitelist.util.ModData;
import com.awakenedredstone.autowhitelist.util.Stonecutter;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedPlayerProfile;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelist;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelistEntry;
import com.awakenedredstone.autowhitelist.whitelist.WhitelistCache;
import com.awakenedredstone.autowhitelist.whitelist.WhitelistCacheEntry;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3330;
import net.minecraft.class_3337;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.SERVER)
public class AutoWhitelist
implements DedicatedServerModInitializer {
    public static final String MOD_ID = "autowhitelist";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"AutoWhitelist");
    public static final Logger DATA_FIXER_LOGGER = LoggerFactory.getLogger((String)"AutoWhitelist Data Fixer");
    public static final AutoWhitelistConfig CONFIG = new AutoWhitelistConfig();
    public static final File WHITELIST_CACHE_FILE = new File("whitelist-cache.json");
    private static MinecraftServer server;

    public static void removePlayer(ExtendedPlayerProfile profile) {
        if (server.method_3760().method_14590().method_14653((GameProfile)profile)) {
            server.method_3760().method_14590().method_14638((class_3330)new ExtendedWhitelistEntry(profile));
        }
        if (AutoWhitelist.getServer().method_3760().method_14614()) {
            AutoWhitelist.getServer().method_3728(AutoWhitelist.getServer().method_3739());
        }
    }

    public static class_2168 getCommandSource() {
        class_3218 serverWorld = server.method_30002();
        return new class_2168((class_2165)server, serverWorld == null ? class_243.field_1353 : class_243.method_24954((class_2382)serverWorld.method_43126()), class_241.field_1340, serverWorld, AutoWhitelist.CONFIG.commandPermissionLevel, "AutoWhitelist", (class_2561)class_2561.method_43470((String)"AutoWhitelist"), server, null);
    }

    public static void loadWhitelistCache() {
        if (!AutoWhitelist.CONFIG.enableWhitelistCache) {
            return;
        }
        if (!WHITELIST_CACHE_FILE.exists()) {
            try {
                AutoWhitelist.getWhitelistCache().method_14629();
            }
            catch (IOException e) {
                LOGGER.error("Failed to create whitelist cache!", (Throwable)e);
            }
        }
        try {
            AutoWhitelist.getWhitelistCache().method_14630();
        }
        catch (Throwable exception) {
            LOGGER.error("Failed to load whitelist cache: ", exception);
        }
    }

    public static void updateEntryMap(List<BaseEntryAction> entries) {
        if (DiscordBot.getInstance() == null || DiscordBot.getGuild() == null) {
            return;
        }
        RoleActionMap.clear();
        for (BaseEntryAction entry : entries) {
            for (String roleString : entry.getRoles()) {
                Optional<Role> perhapsRole = DiscordBotHelper.getRoleFromString(roleString);
                if (perhapsRole.isPresent()) {
                    RoleActionMap.register(perhapsRole.get(), entry);
                    continue;
                }
                LOGGER.warn("Invalid role \"{}\", ignoring", (Object)roleString);
            }
        }
    }

    public void onInitializeServer() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> DiscordBot.stopBot(true), "JDA shutdown"));
        CONFIG.registerListener("entries", entries -> {
            for (BaseEntryAction entry : entries) {
                if (entry.isValid()) continue;
                AutoWhitelistConfig.getLogger().error("Failed to validate entry {}", (Object)entry);
            }
            AutoWhitelist.updateEntryMap(entries);
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            AutoWhitelist.server = server;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> AutoWhitelistCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> DiscordBot.stopBot(false));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            CONFIG.load();
            AutoWhitelist.loadWhitelistCache();
            if (!(server.method_3760().method_14590() instanceof ExtendedWhitelist)) {
                LOGGER.error("Failed to replace whitelist, the mod can not work without the custom system!");
            }
            DiscordBot.startInstance();
            if (!server.method_3828()) {
                LOGGER.warn("***** OFFLINE SERVER DETECTED! *****");
                LOGGER.warn("This mod does not offer support for offline servers!");
                LOGGER.warn("Using a whitelist on an offline server offers little to no protection");
                LOGGER.warn("AutoWhitelist may not work properly, fully or at all on an offline server");
            }
        });
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            if (!AutoWhitelist.CONFIG.enableWhitelistCache) {
                return;
            }
            if (!AutoWhitelist.getServer().method_3828()) {
                return;
            }
            if (!DiscordBot.botExists()) {
                return;
            }
            if (DiscordBot.getGuild() == null) {
                return;
            }
            ServerLoginNetworkHandlerAccessor accessor = (ServerLoginNetworkHandlerAccessor)handler;
            GameProfile profile = accessor.getProfile();
            if (handler.method_14383() == null) {
                return;
            }
            class_2561 canJoin = AutoWhitelist.getServer().method_3760().method_14586(accessor.getConnection().method_10755(), profile);
            if (canJoin != null && !canJoin.equals((Object)class_2561.method_43471((String)"multiplayer.disconnect.not_whitelisted"))) {
                return;
            }
            WhitelistCacheEntry cachedEntry = AutoWhitelist.getWhitelistCache().get(profile);
            if (cachedEntry == null) {
                return;
            }
            String discordId = cachedEntry.getProfile().getDiscordId();
            Member member = DiscordBot.getGuild().getMemberById(discordId);
            if (member == null) {
                AutoWhitelist.getWhitelistCache().remove(profile);
                return;
            }
            Optional<Role> role = DiscordBotHelper.getHighestEntryRole(member);
            if (role.isEmpty()) {
                return;
            }
            BaseEntryAction entry = RoleActionMap.get(role.get());
            if (!entry.isValid()) {
                LOGGER.error("Failed to use whitelist cache due to a broken entry {}", (Object)entry);
                return;
            }
            class_3337 whitelist = server.method_3760().method_14590();
            ExtendedPlayerProfile extendedProfile = new ExtendedPlayerProfile(Stonecutter.profileId(profile), Stonecutter.profileName(profile), role.get().getId(), discordId, CONFIG.lockTime());
            whitelist.method_14633((class_3330)new ExtendedWhitelistEntry(extendedProfile));
            entry.registerUser(extendedProfile);
        });
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static WhitelistCache getWhitelistCache() {
        return ((WhitelistCacheHolder)AutoWhitelist.getServer().method_3760()).autoWhitelist$getWhitelistCache();
    }

    public static class_2960 id(String path) {
        return class_2960.method_43902((String)MOD_ID, (String)path);
    }

    static {
        BaseEntryAction.register(WhitelistEntryAction.ID, WhitelistEntryAction.CODEC);
        BaseEntryAction.register(VanillaTeamEntryAction.ID, VanillaTeamEntryAction.CODEC);
        BaseEntryAction.register(CommandEntryAction.ID, CommandEntryAction.CODEC);
        if (ModData.isModLoaded("luckperms")) {
            BaseEntryAction.register(PermissionEntryAction.ID, PermissionEntryAction.CODEC);
            BaseEntryAction.register(GroupEntryAction.ID, GroupEntryAction.CODEC);
        }
        BaseEntryAction.addDataFixer(VanillaTeamEntryAction.ID, (configVersion, entryData) -> {
            if (configVersion == 1) {
                JsonObject execute = new JsonObject();
                JsonUtil.moveAndRename(entryData, execute, "team", "associate_team");
                entryData.put("execute", (JsonElement)execute);
            }
            return entryData;
        });
        BaseEntryAction.addDataFixer(CommandEntryAction.ID, (configVersion, entryData) -> {
            if (configVersion == 1) {
                JsonObject execute = new JsonObject();
                JsonUtil.moveAndRename(entryData, execute, "addCommand", "on_add");
                JsonUtil.moveAndRename(entryData, execute, "removeCommand", "on_remove");
                entryData.put("execute", (JsonElement)execute);
            }
            return entryData;
        });
        if (ModData.isModLoaded("luckperms")) {
            BaseEntryAction.addDataFixer(PermissionEntryAction.ID, (configVersion, entryData) -> {
                if (configVersion == 1) {
                    JsonObject execute = new JsonObject();
                    JsonUtil.move(entryData, execute, "permission");
                    entryData.put("execute", (JsonElement)execute);
                }
                return entryData;
            });
            BaseEntryAction.addDataFixer(GroupEntryAction.ID, (configVersion, entryData) -> {
                if (configVersion == 1) {
                    JsonObject execute = new JsonObject();
                    JsonUtil.move(entryData, execute, "group");
                    entryData.put("execute", (JsonElement)execute);
                }
                return entryData;
            });
        }
    }
}

