/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.discord.command.admin;

import com.awakenedredstone.autowhitelist.AutoWhitelist;
import com.awakenedredstone.autowhitelist.LazyConstants;
import com.awakenedredstone.autowhitelist.discord.DiscordBotHelper;
import com.awakenedredstone.autowhitelist.discord.api.ReplyCallback;
import com.awakenedredstone.autowhitelist.discord.command.RegisterCommand;
import com.awakenedredstone.autowhitelist.discord.command.SimpleSlashCommand;
import com.awakenedredstone.autowhitelist.entry.BaseEntryAction;
import com.awakenedredstone.autowhitelist.entry.RoleActionMap;
import com.awakenedredstone.autowhitelist.lib.jda.api.Permission;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Member;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Role;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.Command;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.OptionMapping;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.OptionType;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.build.OptionData;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.messages.MessageCreateData;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.messages.MessageEditData;
import com.awakenedredstone.autowhitelist.lib.jdautils.command.SlashCommandEvent;
import com.awakenedredstone.autowhitelist.networking.GeyserProfileRepository;
import com.awakenedredstone.autowhitelist.util.Stonecutter;
import com.awakenedredstone.autowhitelist.util.Validation;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedPlayerProfile;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelist;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelistEntry;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ModifyCommand
extends SimpleSlashCommand {
    public ModifyCommand() {
        super("modify", "admin");
        this.userPermissions = new Permission[]{Permission.MANAGE_ROLES};
        this.options.add(new OptionData(OptionType.USER, "user", this.argumentText("user")).setRequired(true));
        this.options.add(new OptionData(OptionType.STRING, "username", this.argumentText("username")).setRequired(true));
        if (LazyConstants.isUsingGeyser()) {
            this.options.add(new OptionData(OptionType.STRING, "account_type", this.argumentText("geyser")).addChoices(new Command.Choice(this.choice("geyser", "java"), "java"), new Command.Choice(this.choice("geyser", "bedrock"), "bedrock")).setRequired(false));
        }
    }

    @Override
    protected void execute(SlashCommandEvent event) {
        GameProfile profile;
        boolean sameAccount;
        UUID uuid;
        ReplyCallback.DefaultInteractionReplyCallback replyCallback = new ReplyCallback.DefaultInteractionReplyCallback(event);
        MessageCreateData initialReply = (MessageCreateData)DiscordBotHelper.buildEmbedMessage(false, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.feedback.received.title"), (class_2561)class_2561.method_43471((String)"discord.command.feedback.received.message"), DiscordBotHelper.MessageType.NORMAL));
        replyCallback.sendMessage(initialReply);
        @NotNull Member member = Objects.requireNonNull(event.getOption("user", OptionMapping::getAsMember));
        @NotNull String username = Objects.requireNonNull(event.getOption("username", OptionMapping::getAsString));
        boolean geyser = event.getOption("account_type", "java", OptionMapping::getAsString).equalsIgnoreCase("bedrock");
        try {
            uuid = UUID.fromString(username);
        }
        catch (IllegalArgumentException e) {
            uuid = null;
        }
        String id = member.getId();
        Optional<Role> highestRole = DiscordBotHelper.getHighestEntryRole(member);
        if (highestRole.isEmpty()) {
            replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.modify.fail.not_allowed.title"), (class_2561)class_2561.method_43471((String)"discord.command.modify.fail.not_allowed.message"), DiscordBotHelper.MessageType.NORMAL)));
            return;
        }
        MinecraftServer server = AutoWhitelist.getServer();
        ExtendedWhitelist whitelist = (ExtendedWhitelist)server.method_3760().method_14590();
        Optional<ExtendedWhitelistEntry> whitelistedAccount = RegisterCommand.getWhitelistedAccount(id, whitelist);
        if (whitelistedAccount.isPresent() && (sameAccount = uuid != null ? Stonecutter.profileId(whitelistedAccount.get().getProfile()).equals(uuid) : Stonecutter.profileName(whitelistedAccount.get().getProfile()).equalsIgnoreCase(username))) {
            replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.modify.same_username.title"), (class_2561)class_2561.method_43471((String)"discord.command.modify.same_username.message"), DiscordBotHelper.MessageType.WARNING)));
            return;
        }
        BaseEntryAction entry = RoleActionMap.get(highestRole.get());
        if (!entry.isValid()) {
            replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.fail.title"), (class_2561)class_2561.method_43469((String)"discord.command.fatal.generic", (Object[])new Object[]{"Failed to validate entry action"}), DiscordBotHelper.MessageType.FATAL)));
            AutoWhitelist.LOGGER.error("Failed to whitelist user, tried to validate entry {} but failed", (Object)entry);
            return;
        }
        if (uuid == null && !geyser && !Validation.isValidMinecraftUsername(username)) {
            replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.modify.invalid_username.title"), (class_2561)class_2561.method_43471((String)"discord.command.modify.invalid_username.message"), DiscordBotHelper.MessageType.WARNING)));
            return;
        }
        if (Stonecutter.getUserCache(server) == null) {
            AutoWhitelist.LOGGER.error("Failed to whitelist user {}, server user cache is null", (Object)username);
            replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.fail.title"), (class_2561)class_2561.method_43469((String)"discord.command.modify.fatal", (Object[])new Object[]{"Failed to whitelist user %s, server user cache is null".formatted(username)}), DiscordBotHelper.MessageType.ERROR)));
            return;
        }
        if (uuid != null) {
            profile = LazyConstants.isUsingGeyser() ? (uuid.getMostSignificantBits() == 0L || geyser ? new GameProfile(uuid, "Bedrock Player") : (GameProfile)Stonecutter.getUserCache(server).method_14512(uuid).orElse(null)) : (GameProfile)Stonecutter.getUserCache(server).method_14512(uuid).orElse(null);
        } else if (LazyConstants.isUsingGeyser() && geyser) {
            final AtomicReference atomicProfile = new AtomicReference();
            final AtomicReference atomicException = new AtomicReference();
            ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){

                public void onProfileLookupSucceeded(GameProfile profile) {
                    atomicProfile.set(profile);
                }

                public void onProfileLookupFailed(GameProfile name, Exception exception) {
                    if (!(exception instanceof ProfileNotFoundException)) {
                        atomicException.set(exception);
                    }
                    atomicProfile.set(null);
                }
            };
            GeyserProfileRepository repository = LazyConstants.getGeyserProfileRepository();
            repository.findProfilesByNames(new String[]{username}, Agent.MINECRAFT, profileLookupCallback);
            if (atomicException.get() != null) {
                Exception exception = (Exception)atomicException.get();
                AutoWhitelist.LOGGER.error("Failed to get Bedrock profile due to an exception", (Throwable)exception);
                replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.fail.title"), (class_2561)class_2561.method_43469((String)"discord.command.fatal.exception", (Object[])new Object[]{exception}), DiscordBotHelper.MessageType.FATAL)));
                return;
            }
            if (atomicProfile.get() == null) {
                replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.modify.unknown_bedrock_profile.title"), (class_2561)class_2561.method_43471((String)"discord.command.modify.unknown_bedrock_profile.message"), DiscordBotHelper.MessageType.WARNING)));
                return;
            }
            profile = (GameProfile)atomicProfile.get();
        } else {
            profile = Stonecutter.getUserCache(server).method_14515(username).orElse(null);
        }
        if (profile == null) {
            replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.fail.title"), (class_2561)class_2561.method_43469((String)"discord.command.modify.fail.account_data", (Object[])new Object[]{username}), DiscordBotHelper.MessageType.ERROR)));
            return;
        }
        if (AutoWhitelist.getServer().method_3760().method_14563().method_14650(profile)) {
            replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.modify.player_banned.title"), (class_2561)class_2561.method_43471((String)"discord.command.modify.player_banned.message"), DiscordBotHelper.MessageType.ERROR)));
            return;
        }
        ExtendedPlayerProfile extendedProfile = new ExtendedPlayerProfile(Stonecutter.profileId(profile), Stonecutter.profileName(profile), highestRole.get().getId(), id, AutoWhitelist.CONFIG.lockTime());
        boolean whitelisted = whitelist.isAllowed(extendedProfile);
        if (whitelisted) {
            replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.modify.username_already_registered.title"), (class_2561)class_2561.method_43471((String)"discord.command.modify.username_already_registered.message"), DiscordBotHelper.MessageType.ERROR)));
        } else {
            replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.modify.last_steps.title"), (class_2561)class_2561.method_43471((String)"discord.command.modify.last_steps.message"), DiscordBotHelper.MessageType.INFO)));
            RegisterCommand.whitelistPlayer(whitelistedAccount.orElse(null), whitelist, extendedProfile, entry);
            replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43469((String)"discord.command.modify.success.title", (Object[])new Object[]{member.getEffectiveName()}), (class_2561)class_2561.method_43469((String)"discord.command.modify.success.message", (Object[])new Object[]{member.getAsMention(), username}), DiscordBotHelper.MessageType.SUCCESS)));
        }
    }
}

