/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.discord.command.admin;

import com.awakenedredstone.autowhitelist.AutoWhitelist;
import com.awakenedredstone.autowhitelist.discord.DiscordBotHelper;
import com.awakenedredstone.autowhitelist.discord.api.ReplyCallback;
import com.awakenedredstone.autowhitelist.discord.command.RegisterCommand;
import com.awakenedredstone.autowhitelist.discord.command.SimpleSlashCommand;
import com.awakenedredstone.autowhitelist.lib.jda.api.EmbedBuilder;
import com.awakenedredstone.autowhitelist.lib.jda.api.Permission;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.IMentionable;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Member;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.MessageEmbed;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Role;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.OptionMapping;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.OptionType;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.build.OptionData;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.messages.MessageEditData;
import com.awakenedredstone.autowhitelist.lib.jdautils.command.SlashCommandEvent;
import com.awakenedredstone.autowhitelist.util.Stonecutter;
import com.awakenedredstone.autowhitelist.util.Texts;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedPlayerProfile;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelist;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelistEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;

public class UserInfoCommand
extends SimpleSlashCommand {
    public UserInfoCommand() {
        super("userinfo", "admin");
        this.userPermissions = new Permission[]{Permission.MANAGE_ROLES};
        this.options.add(new OptionData(OptionType.USER, "user", this.argumentText("user")).setRequired(false));
    }

    @Override
    protected void execute(SlashCommandEvent event) {
        ReplyCallback.DefaultInteractionReplyCallback replyCallback = new ReplyCallback.DefaultInteractionReplyCallback(event);
        replyCallback.sendMessage(null);
        ExtendedWhitelist whitelist = (ExtendedWhitelist)AutoWhitelist.getServer().method_3760().method_14590();
        Member member = event.getOption("user", event.getMember(), OptionMapping::getAsMember);
        if (member == null) {
            AutoWhitelist.LOGGER.error("Member is null", (Throwable)new IllegalStateException());
            MessageEmbed embed = DiscordBotHelper.Feedback.buildEmbed((class_2561)class_2561.method_43471((String)"discord.command.fatal.title"), (class_2561)class_2561.method_43469((String)"discord.command.fatal.generic", (Object[])new Object[]{"Member is null"}), DiscordBotHelper.MessageType.FATAL);
            replyCallback.editMessage((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, embed));
            return;
        }
        Optional<ExtendedWhitelistEntry> whitelistedAccount = RegisterCommand.getWhitelistedAccount(member.getId(), whitelist);
        List<Role> roles = DiscordBotHelper.getRolesForMember(member);
        List<Role> validRoles = DiscordBotHelper.getValidRolesForMember(member);
        boolean accepted = DiscordBotHelper.getHighestEntryRole(roles).isPresent();
        EmbedBuilder embed = DiscordBotHelper.Feedback.defaultEmbed((class_2561)class_2561.method_43471((String)"discord.command.userinfo.title"), (class_2561)class_2561.method_43469((String)"discord.command.userinfo.description", (Object[])new Object[]{member.getAsMention()}));
        embed.addField(Texts.translated("discord.command.userinfo.roles", new Object[0]), String.join((CharSequence)" ", roles.stream().map(IMentionable::getAsMention).toList()), false);
        embed.addField(Texts.translated("discord.command.userinfo.valid_roles", new Object[0]), validRoles.isEmpty() ? "None" : String.join((CharSequence)" ", validRoles.stream().map(IMentionable::getAsMention).toList()), false);
        embed.addField(Texts.translated("discord.command.userinfo.whitelisted", new Object[0]), String.valueOf(whitelistedAccount.isPresent()), true);
        embed.addField(Texts.translated("discord.command.userinfo.qualifies", new Object[0]), String.valueOf(accepted), true);
        if (whitelistedAccount.isPresent()) {
            String[] fields;
            ExtendedWhitelistEntry entry = whitelistedAccount.get();
            ExtendedPlayerProfile profile = entry.getProfile();
            for (String field : fields = new String[]{"username", "role", "lock"}) {
                String description;
                String title = Texts.translated("discord.command.info.field.%s.title".formatted(field), new Object[0]);
                if (title.isEmpty()) continue;
                String descriptionKey = "discord.command.info.field.%s.description".formatted(field);
                switch (field) {
                    case "username": {
                        String string = Texts.translated(descriptionKey, Stonecutter.profileName(profile));
                        break;
                    }
                    case "role": {
                        String string = Texts.translated(descriptionKey, "<@&" + profile.getRole() + ">");
                        break;
                    }
                    case "lock": {
                        String time = "future";
                        if (profile.getLockedUntil() == -1L) {
                            time = "permanent";
                        } else if (profile.getLockedUntil() <= System.currentTimeMillis()) {
                            time = "past";
                        }
                        String timeKey = "." + time;
                        String string = Texts.translated(descriptionKey + timeKey, DiscordBotHelper.formatDiscordTimestamp(profile.getLockedUntil()));
                        break;
                    }
                    default: {
                        String string = description = "";
                    }
                }
                if (description.isEmpty()) continue;
                embed.addField(title, description, true);
            }
        }
        replyCallback.submitEdit(interactionHook -> interactionHook.editOriginal((MessageEditData)DiscordBotHelper.buildEmbedMessage(true, embed.build())));
    }
}

