/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.middleman;

import com.awakenedredstone.autowhitelist.lib.jda.api.entities.ISnowflake;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Member;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Message;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.User;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.middleman.GuildChannel;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.middleman.MessageChannel;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.emoji.Emoji;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.sticker.StickerSnowflake;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.RestAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.MessageCreateAction;
import com.awakenedredstone.autowhitelist.lib.jda.internal.utils.Checks;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface GuildMessageChannel
extends GuildChannel,
MessageChannel {
    @Override
    default public boolean canTalk() {
        return this.canTalk(this.getGuild().getSelfMember());
    }

    public boolean canTalk(@Nonnull Member var1);

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> removeReactionById(@Nonnull String var1, @Nonnull Emoji var2, @Nonnull User var3);

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> removeReactionById(long messageId, @Nonnull Emoji emoji, @Nonnull User user) {
        return this.removeReactionById(Long.toUnsignedString(messageId), emoji, user);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> deleteMessages(@Nonnull Collection<Message> messages) {
        Checks.notEmpty(messages, "Messages collection");
        return this.deleteMessagesByIds(messages.stream().map(ISnowflake::getId).collect(Collectors.toList()));
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> deleteMessagesByIds(@Nonnull Collection<String> var1);

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> clearReactionsById(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> clearReactionsById(long messageId) {
        return this.clearReactionsById(Long.toUnsignedString(messageId));
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> clearReactionsById(@Nonnull String var1, @Nonnull Emoji var2);

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> clearReactionsById(long messageId, @Nonnull Emoji emoji) {
        return this.clearReactionsById(Long.toUnsignedString(messageId), emoji);
    }

    @Nonnull
    @CheckReturnValue
    public MessageCreateAction sendStickers(@Nonnull Collection<? extends StickerSnowflake> var1);

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction sendStickers(StickerSnowflake ... stickers) {
        Checks.notEmpty(stickers, "Stickers");
        return this.sendStickers(Arrays.asList(stickers));
    }
}

