/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.util;

public class TimeParser {
    public static int parseTime(String timeString) {
        int time = 0;
        StringBuilder number = new StringBuilder();
        for (char c : timeString.trim().toCharArray()) {
            int multiplier;
            if (Character.isDigit(c)) {
                number.append(c);
                continue;
            }
            switch (c) {
                case 's': {
                    int n = 1;
                    break;
                }
                case 'm': {
                    int n = 60;
                    break;
                }
                case 'h': {
                    int n = 3600;
                    break;
                }
                case 'd': {
                    int n = 86400;
                    break;
                }
                case 'w': {
                    int n = 604800;
                    break;
                }
                case 'M': {
                    int n = 2592000;
                    break;
                }
                case 'y': {
                    int n = 31536000;
                    break;
                }
                default: {
                    int n = multiplier = 0;
                }
            }
            if (multiplier == 0 || number.isEmpty()) continue;
            int num = Integer.parseInt(number.toString()) * multiplier;
            time = time + num < 0 ? Integer.MAX_VALUE : time + num;
            number.setLength(0);
        }
        if (!number.isEmpty()) {
            int num = Integer.parseInt(number.toString());
            time = time + num < 0 ? Integer.MAX_VALUE : time + num;
        }
        return time;
    }
}

