/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.discord;

import com.awakenedredstone.autowhitelist.discord.DiscordBot;
import com.awakenedredstone.autowhitelist.entry.RoleActionMap;
import com.awakenedredstone.autowhitelist.lib.jda.api.EmbedBuilder;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Member;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.MessageEmbed;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Role;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.messages.MessageCreateBuilder;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.messages.MessageData;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.messages.MessageEditBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;

public class DiscordBotHelper
extends DiscordBot {
    public static List<Role> getRolesForMember(Member member) {
        ArrayList<Role> roles = new ArrayList<Role>(member.getRoles());
        roles.add(member.getGuild().getPublicRole());
        return roles;
    }

    public static List<Role> getValidRolesForMember(Member member) {
        return DiscordBotHelper.getRolesForMember(member).stream().filter(RoleActionMap::containsRole).toList();
    }

    public static <T extends MessageData> T buildEmbedMessage(boolean edit, MessageEmbed ... embeds) {
        if (edit) {
            return (T)((MessageEditBuilder)new MessageEditBuilder().setEmbeds(embeds)).build();
        }
        return (T)((MessageCreateBuilder)new MessageCreateBuilder().setEmbeds(embeds)).build();
    }

    public static String formatDiscordTimestamp(long timestamp) {
        return "<t:" + timestamp / 1000L + ":R>";
    }

    public static Optional<Role> getRoleFromString(String roleString) {
        Optional<Role> role;
        if (DiscordBot.getInstance() == null || DiscordBot.getGuild() == null) {
            return Optional.empty();
        }
        if (roleString.charAt(0) == '@') {
            String roleSearch = roleString.equalsIgnoreCase("@everyone") ? roleString : roleString.substring(1);
            List<Role> roles = DiscordBot.getGuild().getRolesByName(roleSearch, true);
            role = !roles.isEmpty() ? Optional.of(roles.get(0)) : Optional.empty();
        } else {
            role = Optional.ofNullable(DiscordBot.getGuild().getRoleById(roleString));
        }
        return role;
    }

    public static Optional<Role> getHighestEntryRole(Member member) {
        return DiscordBotHelper.getHighestEntryRole(DiscordBotHelper.getRolesForMember(member));
    }

    public static Optional<Role> getHighestEntryRole(List<Role> roles) {
        for (Role role : roles) {
            if (!RoleActionMap.containsRole(role)) continue;
            return Optional.of(role);
        }
        return Optional.empty();
    }

    public static enum MessageType {
        DEBUG(new Color(19, 40, 138)),
        NORMAL(0x1FFFFFFF),
        INFO(new Color(176, 154, 15)),
        SUCCESS(new Color(50, 134, 25)),
        WARNING(new Color(208, 102, 21)),
        ERROR(new Color(141, 29, 29)),
        FATAL(new Color(212, 4, 4));

        private final int hexColor;

        private MessageType(Color hexColor) {
            this.hexColor = hexColor.getRGB();
        }

        private MessageType(int hexColor) {
            this.hexColor = hexColor;
        }
    }

    public static class Feedback {
        public static EmbedBuilder defaultEmbed(class_2561 title, class_2561 message) {
            EmbedBuilder embedBuilder = new EmbedBuilder();
            embedBuilder.setTitle(title.getString());
            embedBuilder.setDescription(message.getString());
            embedBuilder.setFooter(class_2561.method_43471((String)"discord.command.feedback.message.signature").getString());
            return embedBuilder;
        }

        public static MessageEmbed buildEmbed(class_2561 title, class_2561 message, MessageType type) {
            return Feedback.defaultEmbed(title, message).setColor(type.hexColor).build();
        }

        public static MessageEmbed buildEmbed(class_2561 title, class_2561 message) {
            return Feedback.buildEmbed(title, message, MessageType.NORMAL);
        }
    }
}

