/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.lib.jda.api.entities.sticker;

import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Guild;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.User;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.sticker.RichSticker;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.sticker.Sticker;
import com.awakenedredstone.autowhitelist.lib.jda.api.managers.GuildStickerManager;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.AuditableRestAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.CacheRestAction;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public interface GuildSticker
extends RichSticker {
    @Override
    @Nonnull
    default public Sticker.Type getType() {
        return Sticker.Type.GUILD;
    }

    public boolean isAvailable();

    public long getGuildIdLong();

    @Nonnull
    default public String getGuildId() {
        return Long.toUnsignedString(this.getGuildIdLong());
    }

    @Nullable
    public Guild getGuild();

    @Nullable
    public User getOwner();

    @Nonnull
    @CheckReturnValue
    public CacheRestAction<User> retrieveOwner();

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    @Nonnull
    @CheckReturnValue
    @Contract(value="->new")
    public GuildStickerManager getManager();
}

