/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.commands;

import com.awakenedredstone.autowhitelist.AutoWhitelist;
import com.awakenedredstone.autowhitelist.commands.api.Permission;
import com.awakenedredstone.autowhitelist.data.DefaultTranslationsDataProvider;
import com.awakenedredstone.autowhitelist.discord.DiscordBot;
import com.awakenedredstone.autowhitelist.lib.jda.api.JDAInfo;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Guild;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.ISnowflake;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Member;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Role;
import com.awakenedredstone.autowhitelist.lib.jda.api.interactions.commands.Command;
import com.awakenedredstone.autowhitelist.lib.jdautils.commons.JDAUtilitiesInfo;
import com.awakenedredstone.autowhitelist.util.LinedStringBuilder;
import com.awakenedredstone.autowhitelist.util.ModData;
import com.awakenedredstone.autowhitelist.util.Stonecutter;
import com.awakenedredstone.autowhitelist.util.TimeParser;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedPlayerProfile;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelist;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3324;
import net.minecraft.class_3330;
import net.minecraft.class_3340;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_7403;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoWhitelistCommand {
    public static final Logger LOGGER = LoggerFactory.getLogger(AutoWhitelistCommand.class);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"autowhitelist").requires(Permission.require("autowhitelist.command", 3))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dump").then(class_2170.method_9247((String)"stats").executes(AutoWhitelistCommand::getInfo))).then(class_2170.method_9247((String)"status").executes(AutoWhitelistCommand::getInfo))).then(class_2170.method_9247((String)"info").executes(AutoWhitelistCommand::getInfo))).then(class_2170.method_9247((String)"config").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)AutoWhitelist.CONFIG.toString()), false);
            return 0;
        }))).then(class_2170.method_9247((String)"mods").executes(context -> {
            ArrayList<ModContainer> mods = new ArrayList<ModContainer>(FabricLoader.getInstance().getAllMods());
            mods.sort(Comparator.comparing(o -> o.getMetadata().getName()));
            LinedStringBuilder builder = new LinedStringBuilder("Detected ", mods.size(), " mods:");
            for (ModContainer mod : mods) {
                ModMetadata modMeta = mod.getMetadata();
                builder.appendLine(modMeta.getName()).append(" - ").append(modMeta.getVersion().getFriendlyString());
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)builder.toString()), false);
            return mods.size();
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").then(class_2170.method_9247((String)"bot").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            source.method_9226(() -> class_2561.method_43470((String)"Restarting bot, please wait."), true);
            DiscordBot.getInstanceSafe().restartBot();
            source.method_9226(() -> class_2561.method_43470((String)"The bot is now starting."), true);
            return 0;
        }))).then(class_2170.method_9247((String)"config").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            source.method_9226(() -> class_2561.method_43470((String)"Reloading configurations."), true);
            AutoWhitelist.CONFIG.load();
            return 0;
        }))).then(class_2170.method_9247((String)"cache").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            source.method_9226(() -> class_2561.method_43470((String)"Reloading cache."), true);
            AutoWhitelist.loadWhitelistCache();
            return 0;
        })))).then(class_2170.method_9247((String)"list").executes(context -> AutoWhitelistCommand.executeList((class_2168)context.getSource())))).then(class_2170.method_9247((String)"fix-duplicate-commands").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            source.method_9226(() -> class_2561.method_43470((String)"Fixing commands..."), false);
            CompletableFuture.runAsync(() -> {
                List<Command> commands = DiscordBot.getJda().retrieveCommands().complete();
                List<String> toRemove = List.of("register", "info", "userinfo", "modify");
                commands.stream().filter(command -> toRemove.contains(command.getName())).map(ISnowflake::getId).forEach(id -> {
                    AutoWhitelist.LOGGER.debug("Removing command with id {}", id);
                    DiscordBot.getJda().deleteCommandById((String)id).submit();
                });
            });
            return 0;
        }))).then(class_2170.method_9247((String)"create-translations-datapack").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            source.method_9226(() -> class_2561.method_43470((String)"Creating datapack"), false);
            Path path = source.method_9211().method_27050(class_5218.field_24186).resolve("autowhitelist_translations");
            FabricDataOutput output = new FabricDataOutput((ModContainer)FabricLoader.getInstance().getModContainer("autowhitelist").get(), path, true);
            DefaultTranslationsDataProvider provider = new DefaultTranslationsDataProvider(output);
            provider.method_10319(class_7403.field_39439).whenComplete((o, throwable) -> {
                try {
                    Files.writeString(path.resolve("pack.mcmeta"), (CharSequence)"{\"pack\": {\"pack_format\": 34,\"description\": \"\"}}", new OpenOption[0]);
                }
                catch (IOException e) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"Failed to create pack.mcmeta for \"autowhitelist_translations\""));
                    LOGGER.error("Failed to create pack.mcmeta for \"autowhitelist_translations\"", (Throwable)e);
                    return;
                }
                source.method_9226(() -> class_2561.method_43470((String)"Created datapack autowhitelist_translations"), false);
            });
            return 0;
        })));
    }

    public static int executeList(class_2168 source) {
        List<ExtendedPlayerProfile> extendedProfiles;
        if (source.method_44023() != null) {
            source.method_44023().method_7353((class_2561)class_2561.method_43470((String)"Loading info..."), true);
        }
        Collection<? extends class_3340> entries = ((ExtendedWhitelist)source.method_9211().method_3760().method_14590()).getEntries();
        List<GameProfile> profiles = entries.stream().map(class_3330::method_14626).filter(profile -> !(profile instanceof ExtendedPlayerProfile)).toList();
        class_5250 list = class_2561.method_43470((String)"");
        if (!profiles.isEmpty()) {
            list.method_27693("Vanilla whitelist:");
            profiles.forEach(player -> list.method_27693("\n").method_27693("    ").method_27693(Stonecutter.profileName(player)));
        }
        if (!(extendedProfiles = entries.stream().map(entry -> {
            ExtendedPlayerProfile profile;
            Object patt0$temp = entry.method_14626();
            return patt0$temp instanceof ExtendedPlayerProfile ? (profile = (ExtendedPlayerProfile)((Object)((Object)patt0$temp))) : null;
        }).filter(Objects::nonNull).toList()).isEmpty()) {
            if (!list.getString().isEmpty()) {
                list.method_27693("\n");
            }
            list.method_27693("Automated whitelist:");
            Guild guild = DiscordBot.getGuild();
            if (guild != null) {
                for (ExtendedPlayerProfile profile2 : extendedProfiles) {
                    list.method_27693("\n").method_27693("    ").method_27693(Stonecutter.profileName(profile2));
                    list.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1063));
                    Member member = guild.getMemberById(profile2.getDiscordId());
                    if (member == null) {
                        list.method_10852((class_2561)class_2561.method_43470((String)"Invalid member").method_27692(class_124.field_1061));
                    } else {
                        list.method_10852((class_2561)class_2561.method_43470((String)member.getUser().getName()).method_27692(class_124.field_1080));
                    }
                    list.method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1063));
                    Role role = guild.getRoleById(profile2.getRole());
                    if (role == null) {
                        list.method_10852((class_2561)class_2561.method_43470((String)"Invalid role").method_27692(class_124.field_1061));
                    } else {
                        list.method_10852((class_2561)class_2561.method_43470((String)("@" + role.getName())).method_27692(class_124.field_1080));
                    }
                    list.method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1063));
                }
            } else {
                list.method_27693("\n").method_27693("    ").method_10852((class_2561)class_2561.method_43470((String)"Failed to get guild!").method_27692(class_124.field_1061));
            }
        }
        if (source.method_44023() != null) {
            source.method_44023().method_7353((class_2561)class_2561.method_43470((String)""), true);
        }
        source.method_9226(() -> list, false);
        return extendedProfiles.size();
    }

    private static String getPlatformName() {
        String loaderName = AutoWhitelistCommand.getLoaderName();
        if (FabricLoader.getInstance().isModLoaded("connectormod")) {
            return loaderName + " - Via Connector";
        }
        return loaderName;
    }

    private static String getLoaderName() {
        return switch (AutoWhitelist.getServer().getServerModName()) {
            case "fabric" -> "Fabric";
            case "quilt" -> "Quilt";
            case "forge" -> "Forge";
            case "neoforge" -> "NeoForge";
            default -> "Unknown";
        };
    }

    private static String getLoaderVersion() {
        return switch (AutoWhitelist.getServer().getServerModName()) {
            case "fabric" -> ModData.getVersion("fabricloader");
            case "quilt" -> ModData.getVersion("quilt_loader");
            case "forge" -> ModData.getVersion("forge");
            case "neoforge" -> ModData.getVersion("neoforge");
            default -> "unknown";
        };
    }

    private static int getInfo(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Generating data dump..."), false);
        class_3324 playerManager = AutoWhitelist.getServer().method_3760();
        CompletableFuture.runAsync(() -> {
            LinedStringBuilder dump = new LinedStringBuilder().append(" ");
            dump.appendLine("==== AutoWhitelist data dump ====");
            dump.appendLine("Minecraft:");
            dump.appendLine("  Minecraft version: ", class_155.method_16673().comp_4025());
            dump.appendLine("  Java version: ", Runtime.version());
            dump.appendLine("  Mod loader: ", AutoWhitelistCommand.getPlatformName());
            if (FabricLoader.getInstance().isModLoaded("connectormod")) {
                dump.appendLine("  Connector version: ", ModData.getVersion("connectormod"));
            }
            dump.appendLine("  Loader version: ", AutoWhitelistCommand.getLoaderVersion());
            dump.appendLine("  Mod version: ", ModData.getVersion("autowhitelist"));
            dump.appendLine("  Total whitelisted players: ", playerManager.method_14560().length);
            dump.appendLine("  Luckperms version: ", ModData.getVersion("luckperms"));
            dump.appendLine();
            dump.appendLine("AutoWhitelist:");
            dump.appendLine("  Config:");
            dump.appendLine("    Total entries: ", AutoWhitelist.CONFIG.entries.size());
            dump.appendLine("    Config exists: ", AutoWhitelist.CONFIG.configExists());
            Object[] objectArray = new Object[2];
            objectArray[0] = "    Config loads: ";
            boolean canConfigLoad = AutoWhitelist.CONFIG.canLoad();
            objectArray[1] = canConfigLoad;
            dump.appendLine(objectArray);
            if (!canConfigLoad) {
                dump.append(" <-- BAD CONFIG! Check the logs for the error cause");
            }
            dump.appendLine("    Lock time: ", TimeParser.parseTime(AutoWhitelist.CONFIG.lockTime));
            dump.appendLine("  Bot:");
            dump.appendLine("    JDA version: ", JDAInfo.VERSION);
            dump.appendLine("    Chewtils version: ", JDAUtilitiesInfo.VERSION);
            dump.appendLine("    Bot status: ", DiscordBot.botExists() ? "online" : "offline");
            if (DiscordBot.botExists()) {
                dump.appendLine("    Gateway ping: ", DiscordBot.getJda().getGatewayPing());
                dump.appendLine("    Rest ping: ", DiscordBot.getJda().getRestPing().complete());
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)dump.toString()), false);
        });
        return 0;
    }
}

