/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.discord.events;

import com.awakenedredstone.autowhitelist.AutoWhitelist;
import com.awakenedredstone.autowhitelist.discord.DiscordBot;
import com.awakenedredstone.autowhitelist.discord.DiscordBotHelper;
import com.awakenedredstone.autowhitelist.discord.PeriodicWhitelistChecker;
import com.awakenedredstone.autowhitelist.entry.BaseEntryAction;
import com.awakenedredstone.autowhitelist.entry.RoleActionMap;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Member;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Role;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.User;
import com.awakenedredstone.autowhitelist.lib.jda.api.events.GenericEvent;
import com.awakenedredstone.autowhitelist.lib.jda.api.events.guild.member.GuildMemberRemoveEvent;
import com.awakenedredstone.autowhitelist.lib.jda.api.events.guild.member.GuildMemberRoleAddEvent;
import com.awakenedredstone.autowhitelist.lib.jda.api.events.guild.member.GuildMemberRoleRemoveEvent;
import com.awakenedredstone.autowhitelist.lib.jda.api.events.session.ReadyEvent;
import com.awakenedredstone.autowhitelist.lib.jda.api.events.session.ShutdownEvent;
import com.awakenedredstone.autowhitelist.lib.jda.api.hooks.ListenerAdapter;
import com.awakenedredstone.autowhitelist.lib.jdautils.commons.waiter.EventWaiter;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedPlayerProfile;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelist;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedWhitelistEntry;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_3330;
import org.jetbrains.annotations.NotNull;

public class CoreEvents
extends ListenerAdapter {
    @Override
    public void onGenericEvent(@NotNull GenericEvent event) {
        if (DiscordBot.eventWaiter != null && !DiscordBot.eventWaiter.isShutdown()) {
            DiscordBot.eventWaiter.onEvent(event);
        }
    }

    @Override
    public void onReady(@NotNull ReadyEvent event) {
        if (!DiscordBot.botExists()) {
            AutoWhitelist.LOGGER.error("The bot was marked as ready but it doesn't exist, refusing to proceed");
            return;
        }
        if (AutoWhitelist.getServer() == null) {
            AutoWhitelist.LOGGER.error("The bot was ready while the server was non existent, refusing to proceed");
            if (DiscordBot.getInstance() != null) {
                DiscordBot.getInstance().interrupt();
            }
            return;
        }
        if (DiscordBot.scheduledUpdate != null) {
            DiscordBot.scheduledUpdate.cancel(false);
            try {
                DiscordBot.scheduledUpdate.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DiscordBot.setGuild(DiscordBot.getJda().getGuildById(AutoWhitelist.CONFIG.discordServerId));
        if (DiscordBot.getGuild() == null) {
            AutoWhitelist.LOGGER.error("Could not find the guild with id {}", (Object)AutoWhitelist.CONFIG.discordServerId);
            return;
        }
        try {
            DiscordBot.scheduledUpdate = DiscordBot.EXECUTOR_SERVICE.scheduleWithFixedDelay(new PeriodicWhitelistChecker(), 0L, AutoWhitelist.CONFIG.periodicCheckDelay, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            AutoWhitelist.LOGGER.error("Failed to schedule the periodic whitelist checker", (Throwable)e);
        }
        DiscordBot.eventWaiter = new EventWaiter();
        AutoWhitelist.updateEntryMap(AutoWhitelist.CONFIG.entries);
        AutoWhitelist.LOGGER.info("Discord bot successfully initialized");
    }

    @Override
    public void onShutdown(@NotNull ShutdownEvent event) {
        if (DiscordBot.scheduledUpdate != null) {
            DiscordBot.scheduledUpdate.cancel(false);
            try {
                DiscordBot.scheduledUpdate.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            DiscordBot.scheduledUpdate = null;
        }
        if (DiscordBot.eventWaiter != null && !DiscordBot.eventWaiter.isShutdown()) {
            DiscordBot.eventWaiter.shutdown();
            DiscordBot.eventWaiter = null;
        }
        DiscordBot.setJda(null);
        DiscordBot.setGuild(null);
    }

    @Override
    public void onGuildMemberRemove(@NotNull GuildMemberRemoveEvent e) {
        User user = e.getUser();
        ExtendedWhitelist whitelist = (ExtendedWhitelist)AutoWhitelist.getServer().method_3760().method_14590();
        List<ExtendedPlayerProfile> players = whitelist.getEntries().stream().filter(entry -> entry.method_14626() instanceof ExtendedPlayerProfile).filter(entry -> user.getId().equals(((ExtendedPlayerProfile)((Object)((Object)entry.method_14626()))).getDiscordId())).map(entry -> (ExtendedPlayerProfile)((Object)((Object)entry.method_14626()))).toList();
        if (players.size() > 1) {
            AutoWhitelist.LOGGER.error("Found more than one registered user with same discord id: {}", (Object)user.getId(), (Object)new IllegalStateException("Could not update the whitelist, found more than one entry with the same discord id."));
            return;
        }
        if (players.isEmpty()) {
            return;
        }
        ExtendedPlayerProfile player = players.get(0);
        if (!AutoWhitelist.getServer().method_3760().method_14569((GameProfile)player)) {
            AutoWhitelist.removePlayer(player);
        }
    }

    @Override
    public void onGuildMemberRoleAdd(@NotNull GuildMemberRoleAddEvent e) {
        AutoWhitelist.LOGGER.debug("User \"{}\" gained the role(s) \"{}\"", (Object)e.getMember().getEffectiveName(), (Object)String.join((CharSequence)", ", e.getRoles().stream().map(Role::getName).toList()));
        this.updateUser(e.getMember());
    }

    @Override
    public void onGuildMemberRoleRemove(@NotNull GuildMemberRoleRemoveEvent e) {
        AutoWhitelist.LOGGER.debug("User \"{}\" lost the role(s) \"{}\"", (Object)e.getMember().getEffectiveName(), (Object)String.join((CharSequence)", ", e.getRoles().stream().map(Role::getName).toList()));
        this.updateUser(e.getMember());
    }

    private void updateUser(Member member) {
        AutoWhitelist.LOGGER.debug("Updating entry for {}", (Object)member.getEffectiveName());
        Optional<Role> role = DiscordBotHelper.getHighestEntryRole(DiscordBotHelper.getRolesForMember(member));
        ExtendedWhitelist whitelist = (ExtendedWhitelist)AutoWhitelist.getServer().method_3760().method_14590();
        List<ExtendedPlayerProfile> profiles = whitelist.getProfilesFromDiscordId(member.getId());
        if (profiles.isEmpty()) {
            return;
        }
        if (profiles.size() > 1) {
            AutoWhitelist.LOGGER.warn("Duplicate entries of Discord user with id {}. All of them will be removed.", (Object)member.getId());
            profiles.forEach(whitelist::remove);
            return;
        }
        ExtendedPlayerProfile profile = profiles.get(0);
        if (role.isEmpty()) {
            AutoWhitelist.removePlayer(profile);
            return;
        }
        BaseEntryAction entry = RoleActionMap.get(role.get());
        BaseEntryAction oldEntry = RoleActionMap.getNullable(profile.getRole());
        if (!profile.getRole().equals(role.get().getId())) {
            if (oldEntry != null && !oldEntry.isValid()) {
                AutoWhitelist.LOGGER.error("Failed to validate old entry {}! Could not update user whitelist for {}", (Object)oldEntry, (Object)member.getEffectiveName());
                return;
            }
            if (!entry.isValid()) {
                AutoWhitelist.LOGGER.error("Failed to validate new entry {}! Could not update user whitelist for {}", (Object)entry, (Object)member.getEffectiveName());
                return;
            }
            whitelist.method_14633((class_3330)new ExtendedWhitelistEntry(profile.withRole(role.get())));
            entry.updateUser(profile, oldEntry);
        }
        if (AutoWhitelist.getServer().method_3760().method_14614()) {
            AutoWhitelist.getServer().method_3728(AutoWhitelist.getServer().method_3739());
        }
    }
}

