/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.lib.jda.internal.entities.channel.mixin.attribute;

import com.awakenedredstone.autowhitelist.lib.jda.api.JDA;
import com.awakenedredstone.autowhitelist.lib.jda.api.Permission;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Webhook;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.attribute.IWebhookContainer;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.unions.IWebhookContainerUnion;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.RestAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.Route;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.AuditableRestAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.WebhookAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.data.DataArray;
import com.awakenedredstone.autowhitelist.lib.jda.internal.JDAImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.entities.EntityBuilder;
import com.awakenedredstone.autowhitelist.lib.jda.internal.entities.WebhookImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.entities.channel.mixin.middleman.GuildChannelMixin;
import com.awakenedredstone.autowhitelist.lib.jda.internal.requests.RestActionImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.requests.restaction.AuditableRestActionImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.requests.restaction.WebhookActionImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.utils.Checks;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public interface IWebhookContainerMixin<T extends IWebhookContainerMixin<T>>
extends IWebhookContainer,
IWebhookContainerUnion,
GuildChannelMixin<T> {
    @Override
    @Nonnull
    default public RestAction<List<Webhook>> retrieveWebhooks() {
        this.checkAttached();
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Route.CompiledRoute route = Route.Channels.GET_WEBHOOKS.compile(this.getId());
        JDAImpl jda = (JDAImpl)this.getJDA();
        return new RestActionImpl<List<Webhook>>((JDA)jda, route, (response, request) -> {
            DataArray array = response.getArray();
            ArrayList<WebhookImpl> webhooks = new ArrayList<WebhookImpl>(array.length());
            EntityBuilder builder = jda.getEntityBuilder();
            for (int i = 0; i < array.length(); ++i) {
                try {
                    webhooks.add(builder.createWebhook(array.getObject(i)));
                    continue;
                }
                catch (UncheckedIOException | NullPointerException e) {
                    JDAImpl.LOG.error("Error while creating websocket from json", (Throwable)e);
                }
            }
            return Collections.unmodifiableList(webhooks);
        });
    }

    @Override
    @Nonnull
    default public WebhookAction createWebhook(@Nonnull String name) {
        Checks.notBlank(name, "Webhook name");
        name = name.trim();
        Checks.notEmpty(name, "Name");
        Checks.notLonger(name, 100, "Name");
        this.checkAttached();
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        return new WebhookActionImpl(this.getJDA(), this, name);
    }

    @Override
    @Nonnull
    default public AuditableRestAction<Void> deleteWebhookById(@Nonnull String id) {
        Checks.isSnowflake(id, "Webhook ID");
        this.checkAttached();
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Route.CompiledRoute route = Route.Webhooks.DELETE_WEBHOOK.compile(id);
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }
}

