/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.lib.jda.internal.entities.emoji;

import com.awakenedredstone.autowhitelist.lib.jda.api.JDA;
import com.awakenedredstone.autowhitelist.lib.jda.api.Permission;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Role;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.User;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.emoji.ApplicationEmoji;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.emoji.CustomEmoji;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.emoji.Emoji;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.emoji.EmojiUnion;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.emoji.RichCustomEmoji;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.emoji.UnicodeEmoji;
import com.awakenedredstone.autowhitelist.lib.jda.api.exceptions.ErrorResponseException;
import com.awakenedredstone.autowhitelist.lib.jda.api.exceptions.InsufficientPermissionException;
import com.awakenedredstone.autowhitelist.lib.jda.api.managers.CustomEmojiManager;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.ErrorResponse;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.Route;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.AuditableRestAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.CacheRestAction;
import com.awakenedredstone.autowhitelist.lib.jda.api.utils.data.DataObject;
import com.awakenedredstone.autowhitelist.lib.jda.internal.JDAImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.entities.GuildImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.managers.CustomEmojiManagerImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.requests.DeferredRestAction;
import com.awakenedredstone.autowhitelist.lib.jda.internal.requests.RestActionImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.requests.restaction.AuditableRestActionImpl;
import com.awakenedredstone.autowhitelist.lib.jda.internal.utils.EntityString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class RichCustomEmojiImpl
implements RichCustomEmoji,
EmojiUnion {
    private final long id;
    private final JDAImpl api;
    private final Set<Role> roles;
    private GuildImpl guild;
    private boolean managed = false;
    private boolean available = true;
    private boolean animated = false;
    private String name;
    private User owner;

    public RichCustomEmojiImpl(long id, GuildImpl guild) {
        this.id = id;
        this.api = guild.getJDA();
        this.guild = guild;
        this.roles = ConcurrentHashMap.newKeySet();
    }

    @Override
    @Nonnull
    public Emoji.Type getType() {
        return Emoji.Type.CUSTOM;
    }

    @Override
    @Nonnull
    public String getAsReactionCode() {
        return this.name + ":" + this.id;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        return DataObject.empty().put("name", this.name).put("animated", this.animated).put("id", this.id);
    }

    @Override
    @Nonnull
    public GuildImpl getGuild() {
        GuildImpl realGuild = (GuildImpl)this.api.getGuildById(this.guild.getIdLong());
        if (realGuild != null) {
            this.guild = realGuild;
        }
        return this.guild;
    }

    @Override
    @Nonnull
    public List<Role> getRoles() {
        return Collections.unmodifiableList(new ArrayList<Role>(this.roles));
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    @Nonnull
    public JDAImpl getJDA() {
        return this.api;
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public CacheRestAction<User> retrieveOwner() {
        GuildImpl guild = this.getGuild();
        if (!guild.getSelfMember().hasPermission(Permission.MANAGE_GUILD_EXPRESSIONS)) {
            throw new InsufficientPermissionException(guild, Permission.MANAGE_GUILD_EXPRESSIONS);
        }
        return new DeferredRestAction<User, RestActionImpl>(this.api, User.class, this::getOwner, () -> {
            Route.CompiledRoute route = Route.Emojis.GET_EMOJI.compile(guild.getId(), this.getId());
            return new RestActionImpl<User>((JDA)this.api, route, (response, request) -> {
                DataObject data = response.getObject();
                if (data.isNull("user")) {
                    throw ErrorResponseException.create(ErrorResponse.MISSING_PERMISSIONS, response);
                }
                DataObject user = data.getObject("user");
                this.owner = this.api.getEntityBuilder().createUser(user);
                return this.owner;
            });
        });
    }

    @Override
    @Nonnull
    public CustomEmojiManager getManager() {
        return new CustomEmojiManagerImpl(this);
    }

    @Override
    public boolean isAnimated() {
        return this.animated;
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> delete() {
        if (this.managed) {
            throw new UnsupportedOperationException("You cannot delete a managed emoji!");
        }
        if (!this.getGuild().getSelfMember().hasPermission(Permission.MANAGE_GUILD_EXPRESSIONS)) {
            throw new InsufficientPermissionException(this.getGuild(), Permission.MANAGE_GUILD_EXPRESSIONS);
        }
        Route.CompiledRoute route = Route.Emojis.DELETE_EMOJI.compile(this.getGuild().getId(), this.getId());
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    public RichCustomEmojiImpl setName(String name) {
        this.name = name;
        return this;
    }

    public RichCustomEmojiImpl setAnimated(boolean animated) {
        this.animated = animated;
        return this;
    }

    public RichCustomEmojiImpl setManaged(boolean val) {
        this.managed = val;
        return this;
    }

    public RichCustomEmojiImpl setAvailable(boolean available) {
        this.available = available;
        return this;
    }

    public RichCustomEmojiImpl setOwner(User user) {
        this.owner = user;
        return this;
    }

    public Set<Role> getRoleSet() {
        return this.roles;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomEmoji)) {
            return false;
        }
        CustomEmoji other = (CustomEmoji)obj;
        return this.id == other.getIdLong();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return new EntityString(this).setName(this.name).toString();
    }

    public RichCustomEmojiImpl copy() {
        RichCustomEmojiImpl copy = new RichCustomEmojiImpl(this.id, this.getGuild()).setOwner(this.owner).setManaged(this.managed).setAnimated(this.animated).setName(this.name);
        copy.roles.addAll(this.roles);
        return copy;
    }

    @Override
    @Nonnull
    public UnicodeEmoji asUnicode() {
        throw new IllegalStateException("Cannot convert CustomEmoji to UnicodeEmoji!");
    }

    @Override
    @Nonnull
    public CustomEmoji asCustom() {
        return this;
    }

    @Override
    @Nonnull
    public RichCustomEmoji asRich() {
        return this;
    }

    @Override
    @Nonnull
    public ApplicationEmoji asApplication() {
        throw new IllegalStateException("Cannot convert RichCustomEmoji to ApplicationEmoji!");
    }
}

