/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.entry;

import blue.endless.jankson.JsonObject;
import com.awakenedredstone.autowhitelist.whitelist.ExtendedPlayerProfile;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEntryAction {
    private static final Map<class_2960, MapCodec<? extends BaseEntryAction>> ENTRIES = new HashMap<class_2960, MapCodec<? extends BaseEntryAction>>();
    public static final Codec<BaseEntryAction> CODEC = class_2960.field_25139.dispatch(BaseEntryAction::getType, ENTRIES::get);
    private static final Map<class_2960, BiFunction<Byte, JsonObject, JsonObject>> DATA_FIXERS = new HashMap<class_2960, BiFunction<Byte, JsonObject, JsonObject>>();
    protected final Logger LOGGER;
    private final Set<String> roles = new HashSet<String>(1);
    private final class_2960 type;

    protected BaseEntryAction(class_2960 type, List<String> roles) {
        this.type = type;
        this.roles.addAll(roles);
        this.LOGGER = LoggerFactory.getLogger(this.getClass());
    }

    public static void register(class_2960 id, MapCodec<? extends BaseEntryAction> codec) {
        ENTRIES.putIfAbsent(id, codec);
    }

    @ApiStatus.Experimental
    public static void addDataFixer(class_2960 id, BiFunction<Byte, JsonObject, JsonObject> fixer) {
        DATA_FIXERS.put(id, fixer);
    }

    public class_2960 getType() {
        return this.type;
    }

    @ApiStatus.Experimental
    public static Map<class_2960, BiFunction<Byte, JsonObject, JsonObject>> getDataFixers() {
        return Map.copyOf(DATA_FIXERS);
    }

    public List<String> getRoles() {
        return List.copyOf(this.roles);
    }

    public abstract boolean isValid();

    public abstract void registerUser(ExtendedPlayerProfile var1);

    public abstract void removeUser(ExtendedPlayerProfile var1);

    public void updateUser(ExtendedPlayerProfile profile, @Nullable BaseEntryAction oldEntry) {
        if (oldEntry != null) {
            oldEntry.removeUser(profile);
        }
        this.registerUser(profile);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEntryAction)) {
            return false;
        }
        BaseEntryAction baseEntryAction = (BaseEntryAction)o;
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (Objects.equals(this.getRoles(), baseEntryAction.getRoles()) && Objects.equals(this.getType(), baseEntryAction.getType())) {
            return this.equals(baseEntryAction);
        }
        return false;
    }

    @ApiStatus.OverrideOnly
    public abstract boolean equals(BaseEntryAction var1);

    public abstract String toString();
}

