/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.autowhitelist.lib.jda.internal.entities.channel.mixin.concrete;

import com.awakenedredstone.autowhitelist.lib.jda.api.entities.Guild;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.PermissionOverride;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.attribute.IPostContainer;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.concrete.Category;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.channel.concrete.MediaChannel;
import com.awakenedredstone.autowhitelist.lib.jda.api.entities.emoji.UnicodeEmoji;
import com.awakenedredstone.autowhitelist.lib.jda.api.requests.restaction.ChannelAction;
import com.awakenedredstone.autowhitelist.lib.jda.internal.entities.channel.mixin.attribute.IAgeRestrictedChannelMixin;
import com.awakenedredstone.autowhitelist.lib.jda.internal.entities.channel.mixin.attribute.IPostContainerMixin;
import com.awakenedredstone.autowhitelist.lib.jda.internal.entities.channel.mixin.attribute.ISlowmodeChannelMixin;
import com.awakenedredstone.autowhitelist.lib.jda.internal.entities.channel.mixin.attribute.ITopicChannelMixin;
import com.awakenedredstone.autowhitelist.lib.jda.internal.entities.channel.mixin.attribute.IWebhookContainerMixin;
import com.awakenedredstone.autowhitelist.lib.jda.internal.entities.channel.mixin.middleman.StandardGuildChannelMixin;
import com.awakenedredstone.autowhitelist.lib.jda.internal.utils.Checks;
import javax.annotation.Nonnull;

public interface MediaChannelMixin<T extends MediaChannelMixin<T>>
extends MediaChannel,
StandardGuildChannelMixin<T>,
IAgeRestrictedChannelMixin<T>,
ISlowmodeChannelMixin<T>,
IWebhookContainerMixin<T>,
IPostContainerMixin<T>,
ITopicChannelMixin<T> {
    @Override
    @Nonnull
    default public ChannelAction<MediaChannel> createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<MediaChannel> action = guild.createMediaChannel(this.getName()).setNSFW(this.isNSFW()).setTopic(this.getTopic()).setSlowmode(this.getSlowmode()).setAvailableTags(this.getAvailableTags());
        if (this.getRawSortOrder() != -1) {
            action.setDefaultSortOrder(IPostContainer.SortOrder.fromKey(this.getRawSortOrder()));
        }
        if (this.getDefaultReaction() instanceof UnicodeEmoji) {
            action.setDefaultReaction(this.getDefaultReaction());
        }
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParentCategory();
            action.setDefaultReaction(this.getDefaultReaction());
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.getPermissionOverrideMap().valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addMemberPermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addRolePermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }
}

