/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model;

import com.faboslav.friendsandfoes.common.client.render.entity.model.animation.KeyframeModelAnimator;
import com.faboslav.friendsandfoes.common.client.render.entity.state.WildfireRenderState;
import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.animation.WildfireAnimations;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public final class WildfireEntityModel
extends EntityModel<WildfireRenderState> {
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_HELMET = "helmet";
    private static final String MODEL_PART_SHIELDS = "shields";
    private static final String MODEL_PART_FRONT_SHIELD = "frontShield";
    private static final String MODEL_PART_RIGHT_SHIELD = "rightShield";
    private static final String MODEL_PART_BACK_SHIELD = "backShield";
    private static final String MODEL_PART_LEFT_SHIELD = "leftShield";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart helmet;
    private final ModelPart shields;
    private final ModelPart frontShield;
    private final ModelPart rightShield;
    private final ModelPart backShield;
    private final ModelPart leftShield;
    private final List<ModelPart> shieldsModelParts;

    public WildfireEntityModel(ModelPart root) {
        super(root);
        this.root = root;
        this.body = this.root.getChild(MODEL_PART_BODY);
        this.head = this.body.getChild(MODEL_PART_HEAD);
        this.helmet = this.head.getChild(MODEL_PART_HELMET);
        this.shields = this.root.getChild(MODEL_PART_SHIELDS);
        this.frontShield = this.shields.getChild(MODEL_PART_FRONT_SHIELD);
        this.rightShield = this.shields.getChild(MODEL_PART_RIGHT_SHIELD);
        this.backShield = this.shields.getChild(MODEL_PART_BACK_SHIELD);
        this.leftShield = this.shields.getChild(MODEL_PART_LEFT_SHIELD);
        this.shieldsModelParts = this.shields.getAllParts();
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        PartDefinition body = root.addOrReplaceChild(MODEL_PART_BODY, CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -21.0f, -2.0f, 4.0f, 21.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild(MODEL_PART_HEAD, CubeListBuilder.create().texOffs(0, 26).addBox(-4.0f, -5.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-24.0f, (float)0.0f));
        head.addOrReplaceChild(MODEL_PART_HELMET, CubeListBuilder.create().texOffs(0, 43).addBox(-4.0f, -7.5f, -4.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)1.5f, (float)0.0f));
        PartDefinition shields = root.addOrReplaceChild(MODEL_PART_SHIELDS, CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        shields.addOrReplaceChild(MODEL_PART_FRONT_SHIELD, CubeListBuilder.create().texOffs(17, 0).addBox(-5.0f, 3.5f, -9.5f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-22.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        shields.addOrReplaceChild(MODEL_PART_RIGHT_SHIELD, CubeListBuilder.create().texOffs(17, 0).addBox(-5.0f, 3.5f, -9.5f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-22.0f, (float)0.0f, (float)-0.2618f, (float)1.5708f, (float)0.0f));
        shields.addOrReplaceChild(MODEL_PART_BACK_SHIELD, CubeListBuilder.create().texOffs(17, 0).addBox(-5.0f, 3.5f, -9.5f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-22.0f, (float)0.0f, (float)-0.2618f, (float)3.1416f, (float)0.0f));
        shields.addOrReplaceChild(MODEL_PART_LEFT_SHIELD, CubeListBuilder.create().texOffs(17, 0).addBox(-5.0f, 3.5f, -9.5f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-22.0f, (float)0.0f, (float)-0.2618f, (float)-1.5708f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void setupAnim(WildfireRenderState wildfireRenderState) {
        WildfireEntity wildfire = wildfireRenderState.wildfire;
        float limbAngle = wildfireRenderState.walkAnimationPos;
        float limbDistance = wildfireRenderState.walkAnimationSpeed;
        float animationProgress = wildfireRenderState.ageInTicks;
        float headYaw = wildfireRenderState.yRot;
        float headPitch = wildfireRenderState.xRot;
        int activeShieldsCount = wildfire.getActiveShieldsCount();
        for (int i = 0; i < 4; ++i) {
            this.shieldsModelParts.get((int)i).skipDraw = i > activeShieldsCount;
        }
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.updateKeyframeAnimations(wildfire, limbAngle, limbDistance, animationProgress);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void updateKeyframeAnimations(WildfireEntity wildfire, float limbAngle, float limbDistance, float animationProgress) {
        AnimationHolder movementAnimation = wildfire.getMovementAnimation();
        ArrayList<AnimationHolder> animations = wildfire.getTrackedAnimations();
        AnimationContextTracker animationContextTracker = wildfire.getAnimationContextTracker();
        int currentTick = wildfire.tickCount;
        float animationSpeedModifier = wildfire.getAnimationSpeedModifier();
        KeyframeModelAnimator.updateMovementKeyframeAnimations(this, movementAnimation, limbAngle, limbDistance, 1.0f, 1.0f, animationSpeedModifier);
        KeyframeModelAnimator.updateStaticKeyframeAnimation(this, animationContextTracker, WildfireAnimations.SHIELD_ROTATION, currentTick, animationProgress, animationSpeedModifier);
        KeyframeModelAnimator.updateKeyframeAnimations(this, animationContextTracker, animations, currentTick, animationProgress, animationSpeedModifier);
    }
}

