/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.versions;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class VersionedEntity {
    public static EquipmentSlot getEquipmentSlotForItem(InteractionHand hand) {
        EquipmentSlot equipmentSlot = hand.asEquipmentSlot();
        return equipmentSlot;
    }

    public static InteractionResult success(Entity entity) {
        InteractionResult.Success interactionResult = InteractionResult.SUCCESS;
        return interactionResult;
    }

    public static boolean hurt(Entity entity, DamageSource damageSource, float amount) {
        boolean hurtResult = false;
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            hurtResult = entity.hurtServer(serverLevel, damageSource, amount);
        }
        return hurtResult;
    }

    public static void moveTo(Entity entity, double x, double y, double z) {
        entity.snapTo(x, y, z);
    }

    public static void moveTo(Entity entity, double x, double y, double z, float f, float g) {
        entity.snapTo(x, y, z, f, g);
    }

    public static void moveTo(Entity entity, BlockPos blockPos, float f, float g) {
        entity.snapTo(blockPos, f, g);
    }

    public static ItemEntity spawnAtLocation(Entity entity, ItemLike stack) {
        return VersionedEntity.spawnAtLocation(entity, stack, 0.0f);
    }

    public static ItemEntity spawnAtLocation(Entity entity, ItemLike itemLike, float yOffset) {
        return VersionedEntity.spawnAtLocation(entity, new ItemStack(itemLike), yOffset);
    }

    public static ItemEntity spawnAtLocation(Entity entity, ItemStack stack) {
        return VersionedEntity.spawnAtLocation(entity, stack, 0.0f);
    }

    public static ItemEntity spawnAtLocation(Entity entity, ItemStack stack, float yOffset) {
        ItemEntity item = entity.spawnAtLocation((ServerLevel)entity.level(), stack, yOffset);
        return item;
    }
}

