/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.BlockState;

public final class GlareLocateGlowBerriesTask
extends Behavior<GlareEntity> {
    public GlareLocateGlowBerriesTask() {
        super(Map.of((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), MemoryStatus.VALUE_ABSENT, (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get(), MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel world, GlareEntity glare) {
        return FriendsAndFoes.getConfig().enableGlareGriefing && !glare.isLeashed() && !glare.isOrderedToSit() && !glare.isPassenger() && glare.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
    }

    protected void start(ServerLevel world, GlareEntity glare, long time) {
        BlockPos glowBerriesPos = this.findNearestGlowBerries(glare);
        if (glowBerriesPos == null) {
            GlareBrain.setLocatingGlowBerriesCooldown(glare, TimeUtil.rangeOfSeconds((int)10, (int)10));
            return;
        }
        ResourceKey registryKey = glare.level().dimension();
        glare.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get(), (Object)GlobalPos.of((ResourceKey)registryKey, (BlockPos)glowBerriesPos));
    }

    private BlockPos findNearestGlowBerries(GlareEntity glare) {
        int horizontalRange = 16;
        int verticalRange = 8;
        List<BlockPos> glowBerries = this.findAllGlowBerriesInRange(glare.blockPosition(), horizontalRange, verticalRange, blockPos -> {
            BlockState blockState = glare.level().getBlockState(blockPos);
            return CaveVines.hasGlowBerries((BlockState)blockState);
        });
        if (glowBerries.isEmpty()) {
            return null;
        }
        return glowBerries.get(glare.getRandom().nextInt(glowBerries.size()));
    }

    private List<BlockPos> findAllGlowBerriesInRange(BlockPos glarePos, int horizontalRange, int verticalRange, Predicate<BlockPos> condition) {
        ArrayList<BlockPos> buttons = new ArrayList<BlockPos>();
        for (BlockPos blockPos : BlockPos.withinManhattan((BlockPos)glarePos, (int)horizontalRange, (int)verticalRange, (int)horizontalRange)) {
            BlockPos.MutableBlockPos possibleGlowBerriesBlockPos = blockPos.mutable();
            if (!condition.test((BlockPos)possibleGlowBerriesBlockPos)) continue;
            buttons.add((BlockPos)possibleGlowBerriesBlockPos);
        }
        return buttons;
    }
}

