/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model;

import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.ModelPartAnimator;
import com.faboslav.friendsandfoes.common.client.render.entity.model.animation.ModelPartModelAnimator;
import com.faboslav.friendsandfoes.common.client.render.entity.state.GlareRenderState;
import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.util.animation.AnimationMath;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class GlareEntityModel
extends EntityModel<GlareRenderState> {
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling((float)0.4f);
    public static final MeshTransformer ADULT_TRANSFORMER = MeshTransformer.scaling((float)0.8f);
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_EYES = "eyes";
    private static final String MODEL_TOP_AZALEA = "topAzalea";
    private static final String MODEL_BOTTOM_AZALEA = "bottomAzalea";
    private static final String MODEL_SECOND_LAYER = "secondLayer";
    private static final String MODEL_THIRD_LAYER = "thirdLayer";
    private static final String MODEL_FOURTH_LAYER = "fourthLayer";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart eyes;
    private final ModelPart topAzalea;
    private final ModelPart bottomAzalea;
    private final ModelPart secondLayer;
    private final ModelPart thirdLayer;
    private final ModelPart fourthLayer;
    private final ModelPart[] layers;

    public GlareEntityModel(ModelPart root) {
        super(root);
        this.root = root;
        this.body = this.root.getChild(MODEL_PART_BODY);
        this.head = this.body.getChild(MODEL_PART_HEAD);
        this.eyes = this.head.getChild(MODEL_PART_EYES);
        this.topAzalea = this.head.getChild(MODEL_TOP_AZALEA);
        this.bottomAzalea = this.head.getChild(MODEL_BOTTOM_AZALEA);
        this.secondLayer = this.bottomAzalea.getChild(MODEL_SECOND_LAYER);
        this.thirdLayer = this.secondLayer.getChild(MODEL_THIRD_LAYER);
        this.fourthLayer = this.thirdLayer.getChild(MODEL_FOURTH_LAYER);
        this.layers = new ModelPart[]{this.secondLayer, this.thirdLayer, this.fourthLayer};
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild(MODEL_PART_BODY, CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition body = root.getChild(MODEL_PART_BODY);
        body.addOrReplaceChild(MODEL_PART_HEAD, CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, 0.0f, -3.0f, 12.0f, 9.0f, 9.0f, new CubeDeformation(-0.02f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.getChild(MODEL_PART_HEAD);
        head.addOrReplaceChild(MODEL_PART_EYES, CubeListBuilder.create().texOffs(33, 0).addBox(2.0f, -1.0f, -0.3f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(33, 0).addBox(-4.0f, -1.0f, -0.3f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)5.0f, (float)-3.0f));
        head.addOrReplaceChild(MODEL_TOP_AZALEA, CubeListBuilder.create().texOffs(0, 18).addBox(-7.0f, 0.0f, -7.0f, 14.0f, 8.0f, 14.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild(MODEL_BOTTOM_AZALEA, CubeListBuilder.create().texOffs(18, 101).mirror().addBox(-7.0f, 0.75f, -7.0f, 14.0f, 0.0f, 14.0f, new CubeDeformation(-0.01f)).mirror(false).texOffs(0, 40).addBox(-7.0f, -4.0f, -7.0f, 14.0f, 10.0f, 14.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition bottomAzalea = head.getChild(MODEL_BOTTOM_AZALEA);
        bottomAzalea.addOrReplaceChild(MODEL_SECOND_LAYER, CubeListBuilder.create().texOffs(0, 64).addBox(-6.0f, 0.0f, -6.0f, 12.0f, 7.0f, 12.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition secondLayer = bottomAzalea.getChild(MODEL_SECOND_LAYER);
        secondLayer.addOrReplaceChild(MODEL_THIRD_LAYER, CubeListBuilder.create().texOffs(0, 83).addBox(-5.0f, 0.0f, -5.0f, 10.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition thirdLayer = secondLayer.getChild(MODEL_THIRD_LAYER);
        thirdLayer.addOrReplaceChild(MODEL_FOURTH_LAYER, CubeListBuilder.create().texOffs(0, 100).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)128);
    }

    public void setupAnim(GlareRenderState renderState) {
        GlareEntity glare = renderState.glare;
        float limbAngle = renderState.walkAnimationPos;
        float limbDistance = renderState.walkAnimationSpeed;
        float animationProgress = renderState.ageInTicks;
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateEyes(glare);
        this.animateFloating(glare, animationProgress);
        float movementForce = Mth.sin((float)(limbAngle * 0.1f)) * limbDistance * 0.75f;
        float absMovementForce = Math.abs(movementForce);
        if (absMovementForce >= 0.001f) {
            this.head.xRot = AnimationMath.toRadians(40.0f * absMovementForce);
            this.head.zRot = AnimationMath.toRadians(15.0f * movementForce);
            for (ModelPart layer : this.layers) {
                layer.xRot = AnimationMath.toRadians(30.0f * absMovementForce);
                layer.zRot = AnimationMath.toRadians(15.0f * movementForce);
            }
        } else {
            this.head.xRot = AnimationMath.toRadians(0.5f * AnimationMath.sin(animationProgress * 0.125f));
            this.head.zRot = AnimationMath.toRadians(0.5f * AnimationMath.cos(animationProgress * 0.125f));
            for (ModelPart layer : this.layers) {
                layer.xRot = AnimationMath.toRadians(0.75f * AnimationMath.sin(animationProgress * 0.1f));
                layer.zRot = AnimationMath.toRadians(0.75f * AnimationMath.cos(animationProgress * 0.1f));
            }
        }
    }

    private void animateFloating(GlareEntity glare, float animationProgress) {
        float horizontalFloatingOffset;
        float verticalFloatingOffset;
        float horizontalFloatingSpeed;
        float verticalFloatingSpeed = glare.isGrumpy() ? 0.3f : 0.1f;
        float f = horizontalFloatingSpeed = glare.isGrumpy() ? 0.15f : 0.05f;
        if (glare.isOrderedToSit()) {
            verticalFloatingOffset = 0.5f;
            horizontalFloatingOffset = 0.5f;
        } else {
            verticalFloatingOffset = 1.5f;
            horizontalFloatingOffset = 1.0f;
        }
        float targetPivotY = glare.isOrderedToSit() ? 3.0f : 0.11f;
        ModelPartModelAnimator.animateModelPartYPositionBasedOnTicks(glare.getAnimationContextTracker(), this.body, glare.tickCount, targetPivotY, 10);
        if (glare.isGrumpy()) {
            ModelPartAnimator.setXPosition(this.root, AnimationMath.sin(animationProgress, 0.5f));
            ModelPartAnimator.setYPosition(this.root, AnimationMath.absSin(animationProgress, 0.1f));
            ModelPartAnimator.setYRotation(this.root, AnimationMath.sin(animationProgress, 0.05f));
        }
        float verticalFloatingProgress = AnimationMath.sin(animationProgress * verticalFloatingSpeed) * verticalFloatingOffset;
        float horizontalFloatingProgress = AnimationMath.cos(animationProgress * horizontalFloatingSpeed) * horizontalFloatingOffset;
        this.head.y = verticalFloatingProgress;
        this.head.x = horizontalFloatingProgress;
    }

    private void animateEyes(GlareEntity glare) {
        Vec2 targetEyesPositionOffset = glare.getTargetEyesPositionOffset();
        ModelPartModelAnimator.animateModelPartPositionBasedOnTicks(glare.getAnimationContextTracker(), this.eyes, glare.tickCount, this.eyes.x + targetEyesPositionOffset.x, this.eyes.y + targetEyesPositionOffset.y, this.eyes.z, 10);
    }
}

