/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.common.entity.pose.FriendsAndFoesEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.versions.VersionedEntitySpawnReason;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdPieces;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={StrongholdPieces.Library.class})
public abstract class StrongholdGeneratorMixin
extends StructurePiece {
    @Unique
    private boolean isTuffGolemGenerated = false;

    protected StrongholdGeneratorMixin(StructurePieceType type, int length, BoundingBox boundingBox) {
        super(type, length, boundingBox);
    }

    @WrapMethod(method={"postProcess"})
    private void friendsandfoes$generate(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos, Operation<Void> original) {
        original.call(new Object[]{level, structureManager, generator, random, box, chunkPos, pos});
        if (!FriendsAndFoes.getConfig().generateTuffGolemInStronghold || this.isTuffGolemGenerated || random.nextFloat() > 0.75f) {
            return;
        }
        ServerLevel serverWorld = level.getLevel();
        TuffGolemEntity tuffGolem = (TuffGolemEntity)((EntityType)FriendsAndFoesEntityTypes.TUFF_GOLEM.get()).create((Level)serverWorld, VersionedEntitySpawnReason.STRUCTURE);
        if (tuffGolem == null) {
            return;
        }
        ArrayList<Tuple> possibleSpawnPositions = new ArrayList<Tuple>();
        for (int x = 5; x < 8; x += 3) {
            for (int y = 4; y < 12; y += 2) {
                possibleSpawnPositions.add(new Tuple((Object)x, (Object)y));
            }
        }
        Tuple pickedXYPair = (Tuple)possibleSpawnPositions.get(random.nextIntBetweenInclusive(0, possibleSpawnPositions.size() - 1));
        BlockPos.MutableBlockPos tuffGolemPos = this.getWorldPos((Integer)pickedXYPair.getA(), 1, (Integer)pickedXYPair.getB());
        tuffGolem.setPos((float)tuffGolemPos.getX() + 0.5f, tuffGolemPos.getY(), (float)tuffGolemPos.getZ() + 0.5f);
        float randomSpawnYaw = 90.0f * (float)random.nextIntBetweenInclusive(0, 3);
        tuffGolem.setSpawnYaw(randomSpawnYaw);
        ItemStack enchantedBook = Items.BOOK.getDefaultInstance();
        enchantedBook.setCount(1);
        int enchantmentLevel = 30;
        List<Holder<Enchantment>> enchantmentList = this.friendsAndFoes$getEnchantmentList(random, serverWorld.registryAccess(), enchantedBook, enchantmentLevel);
        if (!enchantmentList.isEmpty()) {
            enchantedBook = EnchantmentHelper.enchantItem((RandomSource)random, (ItemStack)enchantedBook, (int)enchantmentLevel, enchantmentList.stream());
        }
        tuffGolem.setItemSlot(EquipmentSlot.MAINHAND, enchantedBook);
        tuffGolem.setPrevEntityPose(FriendsAndFoesEntityPose.STANDING_WITH_ITEM);
        tuffGolem.setEntityPoseWithoutPrevPose(FriendsAndFoesEntityPose.SLEEPING_WITH_ITEM);
        tuffGolem.setHome(tuffGolem.getNewHome());
        boolean isTuffGolemSpawned = level.addFreshEntity((Entity)tuffGolem);
        if (isTuffGolemSpawned) {
            this.isTuffGolemGenerated = true;
        }
    }

    @Unique
    private List<Holder<Enchantment>> friendsAndFoes$getEnchantmentList(RandomSource random, RegistryAccess registryAccess, ItemStack itemStack, int cost) {
        Optional optional = registryAccess.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.IN_ENCHANTING_TABLE);
        if (optional.isEmpty()) {
            return List.of();
        }
        List instances = EnchantmentHelper.selectEnchantment((RandomSource)random, (ItemStack)itemStack, (int)cost, (Stream)((HolderSet.Named)optional.get()).stream());
        if (itemStack.is(Items.ENCHANTED_BOOK) && instances.size() > 1) {
            instances.remove(random.nextInt(instances.size()));
        }
        return instances.stream().map(enchantmentInstance -> enchantmentInstance.enchantment).toList();
    }
}

