/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.versions.VersionedEntitySpawnReason;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatrolSpawner.class})
public final class PatrolSpawnerMixin {
    boolean friendsandfoes$isBiomeSpecificIllagerSpawned = false;

    @ModifyVariable(method={"spawnPatrolMember"}, ordinal=0, at=@At(value="LOAD"))
    private PatrollingMonster friendsandfoes$modifyPatrolEntity(PatrollingMonster patrolEntity, ServerLevel world, BlockPos pos, RandomSource random, boolean captain) {
        Holder biomeEntry = world.getBiome(pos);
        if (!this.friendsandfoes$isBiomeSpecificIllagerSpawned) {
            if (biomeEntry.is(FriendsAndFoesTags.HAS_ILLUSIONER)) {
                patrolEntity = (PatrollingMonster)((EntityType)FriendsAndFoesEntityTypes.ILLUSIONER.get()).create((Level)world, VersionedEntitySpawnReason.PATROL);
            } else if (biomeEntry.is(FriendsAndFoesTags.HAS_ICEOLOGER)) {
                patrolEntity = (PatrollingMonster)((EntityType)FriendsAndFoesEntityTypes.ICEOLOGER.get()).create((Level)world, VersionedEntitySpawnReason.PATROL);
            }
        }
        return patrolEntity;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void friendsandfoes$resetBiomeSpecificIllagerSpawnFlag(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals, CallbackInfo ci) {
        this.friendsandfoes$isBiomeSpecificIllagerSpawned = false;
    }
}

