/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.versions;

import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import org.jetbrains.annotations.Nullable;

public final class VersionedNbt {
    public static String getString(CompoundTag nbt, String key, String defaultValue) {
        return nbt.getStringOr(key, defaultValue);
    }

    public static int getInt(CompoundTag nbt, String key, int defaultValue) {
        return nbt.getIntOr(key, defaultValue);
    }

    public static float getFloat(CompoundTag nbt, String key, float defaultValue) {
        return nbt.getFloatOr(key, defaultValue);
    }

    public static double getDouble(CompoundTag nbt, String key, double defaultValue) {
        return nbt.getDoubleOr(key, defaultValue);
    }

    public static boolean getBoolean(CompoundTag nbt, String key, boolean defaultValue) {
        return nbt.getBooleanOr(key, defaultValue);
    }

    public static CompoundTag getCompound(CompoundTag nbt, String key) {
        return nbt.getCompoundOrEmpty(key);
    }

    public static ListTag getList(CompoundTag nbt, String key) {
        return nbt.getListOrEmpty(key);
    }

    public static void putUUID(CompoundTag saveData, String key, @Nullable UUID uuid) {
        if (uuid == null) {
            return;
        }
        saveData.store(key, UUIDUtil.CODEC, (Object)uuid);
    }

    @Nullable
    public static UUID getUUID(CompoundTag saveData, String key) {
        if (saveData.contains(key)) {
            return saveData.read(key, UUIDUtil.CODEC).orElse(null);
        }
        return null;
    }
}

