/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire.WildfireBarrageAttackTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire.WildfireShockwaveAttackTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire.WildfireSummonBlazeTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;

public final class WildfireBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super WildfireEntity>>> SENSORS;
    private static final UniformInt BARRAGE_ATTACK_COOLDOWN_PROVIDER;
    private static final UniformInt SHOCKWAVE_ATTACK_COOLDOWN_PROVIDER;
    private static final UniformInt SUMMON_BLAZE_COOLDOWN_PROVIDER;
    private static final UniformInt AVOID_MEMORY_DURATION;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.provider(MEMORY_MODULES, SENSORS);
        Brain brain = profile.makeBrain(dynamic);
        WildfireBrain.addCoreActivities((Brain<WildfireEntity>)brain);
        WildfireBrain.addIdleActivities((Brain<WildfireEntity>)brain);
        WildfireBrain.addFightActivities((Brain<WildfireEntity>)brain);
        WildfireBrain.addAvoidActivities((Brain<WildfireEntity>)brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void addCoreActivities(Brain<WildfireEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get()), (Object)new CountDownCooldownTicks((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get()), (Object)new CountDownCooldownTicks((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get())));
    }

    private static void addIdleActivities(Brain<WildfireEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)StartAttacking.create((serverLevel, wildfire) -> true, WildfireBrain::getTarget)), (Object)Pair.of((Object)1, WildfireBrain.makeRandomWanderTask())));
    }

    private static void addFightActivities(Brain<WildfireEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)((Object)new WildfireSummonBlazeTask()), (Object)((Object)new WildfireBarrageAttackTask()), (Object)((Object)new WildfireShockwaveAttackTask())), MemoryModuleType.ATTACK_TARGET);
    }

    private static void addAvoidActivities(Brain<WildfireEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.4f, (int)16, (boolean)true), WildfireBrain.makeRandomWanderTask()), MemoryModuleType.AVOID_TARGET);
    }

    private static RunOne<WildfireEntity> makeRandomWanderTask() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.6f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivities(WildfireEntity wildfire) {
        wildfire.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.IDLE));
    }

    public static void setBarrageAttackCooldown(WildfireEntity wildfire) {
        wildfire.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get(), (Object)BARRAGE_ATTACK_COOLDOWN_PROVIDER.sample(wildfire.getRandom()));
        WildfireBrain.onCooldown(wildfire);
    }

    public static void setShockwaveAttackCooldown(WildfireEntity wildfire) {
        wildfire.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get(), (Object)SHOCKWAVE_ATTACK_COOLDOWN_PROVIDER.sample(wildfire.getRandom()));
        WildfireBrain.onCooldown(wildfire);
    }

    public static void setSummonBlazeCooldown(WildfireEntity wildfire) {
        wildfire.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get(), (Object)SUMMON_BLAZE_COOLDOWN_PROVIDER.sample(wildfire.getRandom()));
        WildfireBrain.onCooldown(wildfire);
    }

    public static boolean shouldRunAway(WildfireEntity wildfire) {
        return wildfire.getBrain().getMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get()).isPresent() && wildfire.getBrain().getMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get()).isPresent() && (wildfire.getBrain().getMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get()).isPresent() || wildfire.getSummonedBlazesCount() == 2);
    }

    public static void onCooldown(WildfireEntity wildfire) {
        if (!WildfireBrain.shouldRunAway(wildfire)) {
            return;
        }
        LivingEntity attackTarget = wildfire.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (attackTarget == null) {
            return;
        }
        WildfireBrain.runAwayFrom(wildfire, attackTarget);
    }

    public static void onAttacked(WildfireEntity wildfire, LivingEntity attacker) {
        WildfireBrain.setAttackTarget(wildfire, attacker);
        if (WildfireBrain.shouldRunAway(wildfire)) {
            WildfireBrain.runAwayFrom(wildfire, attacker);
        }
    }

    private static Optional<? extends LivingEntity> getTarget(ServerLevel level, WildfireEntity wildfire) {
        Player nearestVisibleTargetablePlayer = wildfire.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).orElse(wildfire.level().getNearestPlayer((Entity)wildfire, 32.0));
        if (nearestVisibleTargetablePlayer == null) {
            return Optional.empty();
        }
        return Optional.of(nearestVisibleTargetablePlayer);
    }

    public static void setAttackTarget(WildfireEntity wildfire, LivingEntity target) {
        wildfire.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        wildfire.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, (Object)target, 200L);
    }

    private static void runAwayFrom(WildfireEntity wildfire, LivingEntity target) {
        wildfire.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        wildfire.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        wildfire.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, (long)AVOID_MEMORY_DURATION.sample(wildfire.level().getRandom()));
    }

    static {
        SENSORS = List.of(SensorType.NEAREST_PLAYERS, SensorType.HURT_BY);
        MEMORY_MODULES = List.of(MemoryModuleType.PATH, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.AVOID_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get(), (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get(), (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get());
        SUMMON_BLAZE_COOLDOWN_PROVIDER = UniformInt.of((int)600, (int)1200);
        BARRAGE_ATTACK_COOLDOWN_PROVIDER = UniformInt.of((int)150, (int)300);
        SHOCKWAVE_ATTACK_COOLDOWN_PROVIDER = UniformInt.of((int)150, (int)300);
        AVOID_MEMORY_DURATION = TimeUtil.rangeOfSeconds((int)5, (int)20);
    }
}

