/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.Nullable;

public final class GlareLocateDarkSpotTask
extends Behavior<GlareEntity> {
    public GlareLocateDarkSpotTask() {
        super(Map.of((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), MemoryStatus.VALUE_ABSENT, (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), MemoryStatus.VALUE_ABSENT), 1);
    }

    protected boolean checkExtraStartConditions(ServerLevel world, GlareEntity glare) {
        return GlareLocateDarkSpotTask.canLocateDarkSpot(glare);
    }

    protected void start(ServerLevel world, GlareEntity glare, long time) {
        BlockPos darkSpotPos = this.findRandomDarkSpot(glare);
        if (darkSpotPos == null) {
            GlareBrain.setDarkSpotLocatingCooldown(glare, TimeUtil.rangeOfSeconds((int)10, (int)10));
            return;
        }
        ResourceKey registryKey = glare.level().dimension();
        glare.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), (Object)GlobalPos.of((ResourceKey)registryKey, (BlockPos)darkSpotPos));
    }

    private ArrayList<BlockPos> findDarkSpots(GlareEntity glare) {
        ServerLevel serverWorld = (ServerLevel)glare.level();
        BlockPos blockPos = glare.blockPosition();
        ArrayList<BlockPos> darkSpots = new ArrayList<BlockPos>();
        int searchDistance = 16;
        int i = 0;
        while ((double)i <= (double)searchDistance) {
            int j = 0;
            while ((double)j < (double)searchDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        boolean isBlockAccessible;
                        BlockPos.MutableBlockPos possibleDarkSpotBlockPos = new BlockPos.MutableBlockPos();
                        possibleDarkSpotBlockPos.setWithOffset((Vec3i)blockPos, k, i - 1, l);
                        boolean isBlockWithinDistance = blockPos.closerThan((Vec3i)possibleDarkSpotBlockPos, (double)searchDistance);
                        boolean isSpotDarkEnough = glare.level().getBrightness(LightLayer.BLOCK, (BlockPos)possibleDarkSpotBlockPos) == 0;
                        boolean isBlockSolidSurface = serverWorld.getBlockState(possibleDarkSpotBlockPos.below()).entityCanStandOn((BlockGetter)serverWorld, (BlockPos)possibleDarkSpotBlockPos, (Entity)glare);
                        boolean bl = isBlockAccessible = serverWorld.isEmptyBlock((BlockPos)possibleDarkSpotBlockPos) && serverWorld.isEmptyBlock(possibleDarkSpotBlockPos.above());
                        if (isBlockWithinDistance && isBlockSolidSurface && isBlockAccessible && isSpotDarkEnough) {
                            darkSpots.add((BlockPos)possibleDarkSpotBlockPos);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return darkSpots;
    }

    @Nullable
    private BlockPos findRandomDarkSpot(GlareEntity glare) {
        ArrayList<BlockPos> darkSpots = this.findDarkSpots(glare);
        if (darkSpots.isEmpty()) {
            return null;
        }
        return darkSpots.get(glare.getRandom().nextInt(darkSpots.size()));
    }

    public static boolean canLocateDarkSpot(GlareEntity glare) {
        Level level = glare.level();
        boolean isDay = level.isBrightOutside();
        boolean canSeeSky = level.canSeeSky(glare.blockPosition());
        return !glare.isLeashed() && !glare.isOrderedToSit() && !glare.isPassenger() && !glare.isBaby() && glare.isTame() && (!isDay || !canSeeSky);
    }
}

